package com.yeejoin.amos.patrol.service.business.service.impl;

import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.DepartmentModel;
import com.yeejoin.amos.patrol.common.entity.UserModel;
import com.yeejoin.amos.patrol.service.business.dao.mapper.TaskReportMapper;
import com.yeejoin.amos.patrol.service.remote.RemoteSecurityService;
//import com.yeejoin.amos.security.common.model.UserModel;

import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Component
public class TaskReportServiceImpl {

    public static final String STATISTICAL_TYPE_POINT = "POINT"; //按检查点
    public static final String STATISTICAL_TYPE_ROUTE = "ROUTE";//按路线
    public static final String STATISTICAL_TYPE_DEPT = "DEPT";//按部门
    public static final String STATISTICAL_TYPE_USER = "USER";//按用户
    public static final String STATISTICAL_TYPE_PLAN = "PLAN";//按计划


    @Autowired
    private RemoteSecurityService remoteSecurityService;
    @Autowired
    private TaskReportMapper taskReportMapper;


    public Map<String, Object> queryForTaskReport(String toke,String product,String appKey,String statisticalType, String orgCode, String startDate, String endDate, Integer planId, Integer routeId) {
        Map<String, Object> returnMap = new HashMap<>();
        List<Map> result = new ArrayList<>();
        Map summation = new HashMap();
        switch (statisticalType) {
            case STATISTICAL_TYPE_DEPT:
                result = taskReportMapper.queryWithDept("false", startDate, endDate, planId, routeId);
                List<Map> summationListDept = taskReportMapper.queryWithDept("true", startDate, endDate, planId, routeId);
                summation = summationListDept.get(0);
                break;
            case STATISTICAL_TYPE_POINT:
                result = taskReportMapper.queryWithPoint("false", orgCode, startDate, endDate, planId, routeId);
                List<Map> summationList = taskReportMapper.queryWithPoint("true", orgCode, startDate, endDate, planId, routeId);
                summation = summationList.get(0);
                break;
            case STATISTICAL_TYPE_ROUTE:
                result = taskReportMapper.queryWithRoute("false", startDate, endDate, planId, routeId);
                List<Map> summationListRoute = taskReportMapper.queryWithRoute("true", startDate, endDate, planId, routeId);
                summation = summationListRoute.get(0);
                break;
            case STATISTICAL_TYPE_USER:
                result = taskReportMapper.queryWithUser("false", startDate, endDate, planId, routeId);
                List<Map> summationListUser = taskReportMapper.queryWithUser("true", startDate, endDate, planId, routeId);
               
              //处理用户信息
                
                
                String userIds="";
                Set<String> set = new HashSet<>();
                result.forEach(s -> {  
                	
                     set.add(s.get("itemName").toString());
                	
                });
                
                List<String> list1 = new ArrayList<>(set);
                userIds = String.join(",", list1);
         
                  
                List<AgencyUserModel> listd=remoteSecurityService.listUserByUserIds( toke, product, appKey, userIds);
                
                //新安全
                result.forEach(s -> {      	
                		 listd.forEach(s1 -> {    
                	    		
                	    		if((s.get("itemName")+"").equals(s1.getUserId())){
                	    			
                	    			 s.put("itemName",s1.getUserName());          	    			         	    		}
                	        	
                	        });          	    	
                	    });
              	
                
                
                
                summation = summationListUser.get(0);
                break;
            case STATISTICAL_TYPE_PLAN:
                result = taskReportMapper.queryWithPlan("false", startDate, endDate, planId, routeId);
                List<Map> summationListPlan = taskReportMapper.queryWithPlan("true", startDate, endDate, planId, routeId);
                summation = summationListPlan.get(0);
                break;
        }

        returnMap.put("dataByMonth", result);
        returnMap.put("summation", summation);
        return returnMap;
    }


    public Map<String, Object> comprehensiveStatisticalForUser(String toke,String product,String appKey,String startTime, String endTime, String code) {

        Map<String, Object> returnMap = new HashMap<>();
        List<Map> result = new ArrayList<>();
        Map summation = new HashMap();

        result = taskReportMapper.comprehensiveStatisticalForUser("false", startTime, endTime,code);
        List<Map> summationListPlan = taskReportMapper.comprehensiveStatisticalForUser("true", startTime, endTime,code);
        summation = summationListPlan.get(0);

        
//处理用户信息
        
        
        String userIds="";
        Set<String> set = new HashSet<>();
        result.forEach(s -> {  
        	
        	
        	 if(s.containsKey("userId")){
             set.add(s.get("userId").toString());
        	 }
        	
        });
        
        List<String> list1 = new ArrayList<>(set);
        userIds = String.join(",", list1);
 
          
        List<AgencyUserModel> listd=remoteSecurityService.listUserByUserIds( toke, product, appKey, userIds);
        
        //新安全
        result.forEach(s -> {      	
        	 
        	    	
        		 listd.forEach(s1 -> {    
        	    		
        	    		if(s.get("userId").toString().equals(s1.getUserId())){
        	    			
        	    			 s.put("userName",s1.getUserName());
        	    			 String deptName="";
        	    			Map<Long, List<DepartmentModel>> map= s1.getCompanyDepartments();
        	    			 for(Long key:map.keySet()){
        	    				 if(map!=null){
        	    					 List<DepartmentModel> value = map.get(key);//
        	    					 
        	    					 if(value!=null&&value.size()>0){
        	    						 for (DepartmentModel departmentModel : value) {
        	    							 if(departmentModel!=null){
                     	    					  deptName=deptName+departmentModel.getDepartmentName()+",";

        	    							 }
          								}  
        	    						 
        	    					 }
           	    				 
        	    					 
        	    				 }
        	    				
        	    				
        	    				 
        	    				 }
        	    				
        	    			 s.put("deptName",deptName); 
             	    		
        	    		}
        	        	
        	        	
        	        });
        	    	
        	    });
        	 
        
        
        returnMap.put("report", result);
        returnMap.put("summation", summation);
        return returnMap;
    }


}
