package com.yeejoin.amos.patrol.service.business.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.DepartmentModel;
//import com.yeejoin.amos.op.core.common.response.CommonResponse;
//import com.yeejoin.amos.op.core.util.CommonResponseUtil;
//import com.yeejoin.amos.op.core.util.DateUtil;
import com.yeejoin.amos.patrol.common.core.response.bo.DepartmentBo;
import com.yeejoin.amos.patrol.common.entity.CommonResponse;
import com.yeejoin.amos.patrol.common.entity.CommonResponseUtil;
import com.yeejoin.amos.patrol.common.entity.DateUtil;
import com.yeejoin.amos.patrol.common.entity.UserModel;
import com.yeejoin.amos.patrol.common.enums.ExecuteStateEnum;
import com.yeejoin.amos.patrol.common.enums.TaskworkStateEnum;
import com.yeejoin.amos.patrol.common.enums.ViolationGradeEnum;
import com.yeejoin.amos.patrol.service.business.bo.spc.RiskFactorBo;
import com.yeejoin.amos.patrol.service.business.bo.spc.TaskworkAuditLogBo;
import com.yeejoin.amos.patrol.service.business.bo.spc.TaskworkBo;
import com.yeejoin.amos.patrol.service.business.bo.spc.TaskworkContentBo;
import com.yeejoin.amos.patrol.service.business.bo.spc.TaskworkMeasuresBo;
import com.yeejoin.amos.patrol.service.business.dao.mapper.RiskFactorMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.TaskworkAuditLogMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.TaskworkContentMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.TaskworkMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.TaskworkMeasuresMapper;
import com.yeejoin.amos.patrol.service.business.param.TaskworkExecuteParam;
import com.yeejoin.amos.patrol.service.business.rulemodel.SpcTaskworkRo;
import com.yeejoin.amos.patrol.service.business.service.intfc.IRiskJudgmentTaskService;
import com.yeejoin.amos.patrol.service.business.service.intfc.ITaskworkService;
import com.yeejoin.amos.patrol.service.business.util.RandomUtil;
import com.yeejoin.amos.patrol.service.business.vo.TaskworkContentVo;
import com.yeejoin.amos.patrol.service.business.vo.TaskworkDetailVo;
import com.yeejoin.amos.patrol.service.business.vo.TaskworkListVo;
import com.yeejoin.amos.patrol.service.business.vo.TaskworkMeasureVo;
import com.yeejoin.amos.patrol.service.core.async.AsyncTask;
import com.yeejoin.amos.patrol.service.core.util.StringUtil;
import com.yeejoin.amos.patrol.service.remote.RemoteSecurityService;
import com.yeejoin.amos.patrol.service.remote.RemoteWorkFlowService;
import com.yeejoin.amos.patrol.service.remote.feign.RemoteRuleServer;
//import com.yeejoin.amos.security.common.model.UserModel;

@Service("taskworkService")
public class TaskworkServiceImpl implements ITaskworkService {

	private final Logger logger = LoggerFactory.getLogger(TaskworkServiceImpl.class);

	@Autowired
	private RemoteWorkFlowService remoteWorkFlowService;

	@Autowired
	private RemoteSecurityService remoteSecurityService;

	@Autowired
	private TaskworkMapper taskworkMapper;

	@Autowired
	private TaskworkAuditLogMapper taskworkAuditLogMapper;

	@Autowired
	private TaskworkContentMapper taskworkContentMapper;

	@Autowired
	private TaskworkMeasuresMapper taskworkMeasuresMapper;

	@Autowired
	private RiskFactorMapper riskFactorMapper;
	
	@Autowired
    private RemoteRuleServer remoteRuleServer;

	@Autowired
	private AsyncTask asyncTask;
	
    @Autowired
    private IRiskJudgmentTaskService iRiskJudgmentTaskService;

	private static final String processDefinitionKey = "D";

	private static final String permissionType = "activitiItem";

	@Transactional
	@Override
	public String startFlow(Long id, String userId, String userRealName, String departmentId, String departmentName,
			String companyId, String orgCode, String token) {
		TaskworkBo taskworkBo = taskworkMapper.getById(id);
		if (taskworkBo == null) {
			return "【" + id + "】作业活动不存在";
		}
		if (TaskworkStateEnum.未启动.getCode().equals(taskworkBo.getStatus())) {
			String businessKey = RandomUtil.buildOrderNo();
			JSONObject startJson = remoteWorkFlowService.start(businessKey, token, companyId, departmentId,
					processDefinitionKey);
			if (startJson == null) {
				return taskworkBo.getName() + "【" + taskworkBo.getId() + "】启动流程失败";
			}
			String instanceId = startJson.getJSONObject("dataList").getString("id");
			JSONObject initFlow = remoteWorkFlowService.currentTask(instanceId, token);
			if (initFlow == null) {
				return taskworkBo.getName() + "【" + taskworkBo.getId() + "】任务已经完成";
			}
			Set<String> initUserIds = getUserIdsStrByPerTypeAndDefKey(initFlow);
			TaskworkAuditLogBo currentRecord = saveFlowRecord(initFlow.getString("id"),
					Joiner.on(",").join(initUserIds), initFlow.getString("name"),
					initFlow.getString("taskDefinitionKey"), id);
			TaskworkBo excuteResult = excuteSubmit(null, null, ExecuteStateEnum.通过, instanceId, id, currentRecord,
					userId, userRealName, departmentId, departmentName, token, orgCode, taskworkBo.getName());
			if (excuteResult == null) {
				TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
				return taskworkBo.getName() + "【" + taskworkBo.getId() + "】执行失败";
			}
			excuteResult.setApplyDate(new Date());
			excuteResult.setApplyDepartmentId(departmentId);
			excuteResult.setApplyUserId(userId);
			excuteResult.setInstanceId(instanceId);
			excuteResult.setBusinessKey(businessKey);
			taskworkMapper.update(excuteResult);
			return taskworkBo.getName() + "【" + taskworkBo.getId() + "】" + "成功";
		} else if (TaskworkStateEnum.待作业活动申请.getCode().equals(taskworkBo.getStatus())) {
			TaskworkAuditLogBo currentRecord = taskworkAuditLogMapper.getById(taskworkBo.getCurrentFlowRecordId());
			TaskworkBo excuteResult = excuteSubmit(null, null, ExecuteStateEnum.通过, taskworkBo.getInstanceId(), id,
					currentRecord, userId, userRealName, departmentId, departmentName, token, orgCode,
					taskworkBo.getName());
			if (excuteResult == null) {
				TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
				return taskworkBo.getName() + "【" + taskworkBo.getId() + "】执行失败";
			}
			taskworkMapper.update(excuteResult);
			return taskworkBo.getName() + "【" + taskworkBo.getId() + "】" + "成功";
		} else {
			return taskworkBo.getName() + "【" + taskworkBo.getId() + "】作业活动流程已启动";
		}
	}

	@Override
	public CommonResponse list(String toke,String product,String appKey,Integer pageNumber, Integer pageSize, String userId, String orgCode,
			Integer canExecutorType, Integer status, Integer level, String taskworkName) {
		Map<String, Object> map = Maps.newHashMap();
		map.put("offset", pageNumber * pageSize);
		map.put("limit", pageSize);
		map.put("orgCode", orgCode);
		map.put("name", taskworkName);
		if (canExecutorType == 1) {
			map.put("userId", userId);
		}
		if (status == 1) {
			map.put("status", 2);
		} else if (status == 2) {
			map.put("status", 3);
		} else if (status == 3) {
			map.put("status", 4);
		} else if (status == 4) {
			map.put("status", 5);
		} else if (status == 5) {
			map.put("status", 6);
		} else if (status == 6) {
			map.put("status", 7);
		}
		if (level != 0) {
			map.put("code", level);
		}
		List<TaskworkBo> list = taskworkMapper.listByMap(map);
		Long count = 0L;
		List<TaskworkListVo> voList = Lists.newArrayList();
		if (!CollectionUtils.isEmpty(list)) {
			Set<String> deptIds = Sets.newHashSet();
			list.forEach(e -> {
				deptIds.add(e.getDepartmentId());
				deptIds.add(e.getGroupId());
			});
			String deptIdsStr = Joiner.on(",").join(deptIds);
			List<LinkedHashMap> departments = remoteSecurityService.listDepartmentByDeptIds( toke, product, appKey,deptIdsStr);
			//Map<Long, DepartmentModel> departmentBoMap = Maps.uniqueIndex(departments, DepartmentModel::getSequenceNbr);
			Map<String, DepartmentModel>   deptMap = new HashMap<>();

	            for (int i = 0; i < departments.size(); i++) {
	            	DepartmentModel departmentBo4 =new DepartmentModel();
	            	departmentBo4.setDepartmentName(departments.get(i).get("departmentName").toString());
	            	deptMap.put(departments.get(i).get("sequenceNbr").toString(),departmentBo4 );
				}
			
			for (TaskworkBo bo : list) {
				TaskworkListVo vo = new TaskworkListVo();
				vo.setBelongDepartmentAndGroupName(buildDeptNameAndGroupName(bo, deptMap));
				vo.setId(bo.getId());
				vo.setTaskworkName(bo.getName());
				vo.setLevelDesc(bo.getLevelDesc());
				vo.setTaskworkState(bo.getStatus());
				TaskworkStateEnum stateEnum = TaskworkStateEnum.getByCode(bo.getStatus());
				if (stateEnum != null) {
					vo.setTaskworkStateDesc(stateEnum.getName());
				}
				voList.add(vo);
			}
			count = taskworkMapper.countByMap(map);
		}
		return CommonResponseUtil.success(new PageImpl<>(voList, null, count));
	}

	private String buildDeptNameAndGroupName(TaskworkBo taskworkBo, Map<String, DepartmentModel> departmentBoMap) {
		String deptNameAndGroupName = "";
		DepartmentModel departmentBo = departmentBoMap.get(taskworkBo.getDepartmentId());
		if (departmentBo != null) {
			deptNameAndGroupName += departmentBo.getDepartmentName();
		}
		String[] groupIds = taskworkBo.getGroupId().split(",");
		List<String> groupNames = new ArrayList<>();
		for (String groupId : groupIds) {			
			DepartmentModel groupBo = departmentBoMap.get(groupId);
			if (null != groupBo) {
				groupNames.add(groupBo.getDepartmentName());
			}
		}
		if (departmentBo != null) {
			deptNameAndGroupName += "-" + StringUtils.collectionToCommaDelimitedString(groupNames);
		}
		return deptNameAndGroupName;
	}

	@Override
	public CommonResponse detail(String toke,String product,String appKey,Long id) {
		TaskworkBo taskworkBo = taskworkMapper.getById(id);
		TaskworkDetailVo detailVo = new TaskworkDetailVo();
		if (taskworkBo != null) {
			Set<String> deptIds = Sets.newHashSet();
			deptIds.add(taskworkBo.getDepartmentId());
			deptIds.add(taskworkBo.getGroupId());
			deptIds.add(taskworkBo.getApplyDepartmentId());
			deptIds.remove("");
			deptIds.remove(null);
			String deptIdsStr = Joiner.on(",").join(deptIds);
			List<LinkedHashMap> departmentBos = remoteSecurityService.listDepartmentByDeptIds( toke, product, appKey,deptIdsStr);
			//Map<String, DepartmentModel> departmentBoMap = Maps.uniqueIndex(departmentBos, DepartmentModel::getSequenceNbr);
			Map<String, DepartmentModel>   deptMap = new HashMap<>();

            for (int i = 0; i < departmentBos.size(); i++) {
            	DepartmentModel departmentBo4 =new DepartmentModel();
            	departmentBo4.setDepartmentName(departmentBos.get(i).get("departmentName").toString());
            	deptMap.put(departmentBos.get(i).get("sequenceNbr").toString(),departmentBo4 );
			}
			
			
			
			detailVo.setId(id);
			detailVo.setTaskworkName(taskworkBo.getName());
			detailVo.setLevelDesc(taskworkBo.getLevelDesc());
			detailVo.setPartName(taskworkBo.getPart());
			detailVo.setPostName(taskworkBo.getPost());
			detailVo.setBelongDepartmentAndGroupName(buildDeptNameAndGroupName(taskworkBo, deptMap));
			AgencyUserModel userModel = remoteSecurityService.getUserById( toke, product, appKey,taskworkBo.getApplyUserId());
			if (userModel != null) {
				detailVo.setApplyUserName(userModel.getRealName());
			}
			DepartmentModel applyBo = deptMap.get(taskworkBo.getApplyDepartmentId()+"");
			if (applyBo != null) {
				detailVo.setApplyDepartmentName(applyBo.getDepartmentName());
			}
			detailVo.setApplyDateTime(DateUtil.date2Str(taskworkBo.getApplyDate(), DateUtil.DATETIME_DEFAULT_FORMAT));
			detailVo.setCurrentFlowRecordId(taskworkBo.getCurrentFlowRecordId());
			setRecordsForDetail( toke, product, appKey,detailVo, id);
		}
		return CommonResponseUtil.success(detailVo);
	}

	private void setRecordsForDetail(String toke,String product,String appKey,TaskworkDetailVo detailVo, Long taskworkId) {
		List<TaskworkAuditLogBo> records = taskworkAuditLogMapper.listByTaskworkId(taskworkId);
		if (!CollectionUtils.isEmpty(records)) {
			Set<String> userIds = Sets.newHashSet();
			Set<String> deptIds = Sets.newHashSet();
			records.forEach(e -> {
				if (!StringUtils.isEmpty(e.getExcuteUserId())) {
					userIds.add(e.getExcuteUserId());
				}
				if (!StringUtils.isEmpty(e.getExcuteDepartmentId())) {
					deptIds.add(e.getExcuteDepartmentId());
				}
			});
			List<LinkedHashMap> departmentBos = remoteSecurityService
					.listDepartmentByDeptIds( toke, product, appKey,Joiner.on(",").join(deptIds));
			List<AgencyUserModel> userModels = remoteSecurityService.listUserByUserIds( toke, product, appKey,Joiner.on(",").join(userIds));
			Map<String, AgencyUserModel> userMap = Maps.uniqueIndex(userModels, AgencyUserModel::getUserId);
			//Map<Long, DepartmentModel> departmentBoMap = Maps.uniqueIndex(departmentBos, DepartmentModel::getSequenceNbr);
			
			Map<String, DepartmentModel>   deptMap = new HashMap<>();

            for (int i = 0; i < departmentBos.size(); i++) {
            	DepartmentModel departmentBo4 =new DepartmentModel();
            	departmentBo4.setDepartmentName(departmentBos.get(i).get("departmentName").toString());
            	deptMap.put(departmentBos.get(i).get("sequenceNbr").toString(),departmentBo4 );
			}
			
			for (TaskworkAuditLogBo recordBo : records) {
				AgencyUserModel user = userMap.get(recordBo.getExcuteUserId());
				if (user != null) {
					recordBo.setExecuteUserName(user.getRealName());
				}
				DepartmentModel departmentBo = deptMap.get(recordBo.getExcuteDepartmentId()+"");
				if (departmentBo != null) {
					recordBo.setExecuteDepartmentName(departmentBo.getDepartmentName());
				}
				recordBo.setExecuteTime(DateUtil.date2Str(recordBo.getUpdateDate(), DateUtil.DATETIME_DEFAULT_FORMAT));
			}
			detailVo.setRecords(records);
		}

	}

	@Transactional
	@Override
	public CommonResponse excute(TaskworkExecuteParam taskworkExecuteParam, String userId, String userRealName,
			String departmentId, String departmentName, String token) {
		JSONObject flowJson = taskworkExecuteParam.getFlowJson();
		Long currentFlowRecordId = taskworkExecuteParam.getCurrentFlowRecordId();
		Integer excuteType = taskworkExecuteParam.getExcuteType();
		String remark = taskworkExecuteParam.getRemark();
		ExecuteStateEnum executeStateEnum = ExecuteStateEnum.getByCode(excuteType);
		if (executeStateEnum == null) {
			return CommonResponseUtil.failure("执行类型有误");
		}
		TaskworkAuditLogBo currentRecord = taskworkAuditLogMapper.getById(currentFlowRecordId);
		if (currentRecord == null) {
			return CommonResponseUtil.failure("工作流记录不存在");
		}
		if (!currentRecord.getExcuteState().equals(ExecuteStateEnum.未执行.getCode())) {
			return CommonResponseUtil.failure("已经被执行");
		}
		TaskworkBo taskworkBo = taskworkMapper.getById(currentRecord.getTaskworkId());
		if (taskworkBo == null) {
			return CommonResponseUtil.failure("作业活动不存在");
		}
		if (!taskworkBo.getCurrentFlowRecordId().equals(currentFlowRecordId)) {
			return CommonResponseUtil.failure("已经被执行");
		}
		if (taskworkBo.getStatus().equals(TaskworkStateEnum.完成.getCode())) {
			return CommonResponseUtil.failure("任务已经完成");
		}
		String userIdsStr = currentRecord.getFlowTaskUserIds();
		List<String> userIds = Arrays.asList(userIdsStr.split(","));
		if (!userIds.contains(userId)) {
			return CommonResponseUtil.failure("无权限执行此任务");
		}
		if (taskworkBo.getStatus().equals(TaskworkStateEnum.待执行.getCode())
				&& executeStateEnum.equals(ExecuteStateEnum.通过)) {
			JSONArray jsonArray = flowJson.getJSONArray("taskworkContents");
			handleExecuteFlowJson(jsonArray);
		} else if (taskworkBo.getStatus().equals(TaskworkStateEnum.待确认验收.getCode())
				&& executeStateEnum.equals(ExecuteStateEnum.通过)) {
			JSONArray jsonArray = flowJson.getJSONArray("taskworkContents");
			handleAcceptFlowJson(jsonArray);
			updateViolateState(taskworkBo);// 更新违章状态
		}
		TaskworkBo excuteResult = excuteSubmit(remark, flowJson, executeStateEnum, taskworkBo.getInstanceId(),
				taskworkBo.getId(), currentRecord, userId, userRealName, departmentId, departmentName, token,
				taskworkBo.getOrgCode(), taskworkBo.getName());
		if (excuteResult == null) {
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
			return CommonResponseUtil.failure("执行失败");
		} else {
			taskworkMapper.update(excuteResult);
			fireRuleByTaskworkStatus(taskworkBo, executeStateEnum, departmentName, userRealName);
			if(StringUtil.isNotEmpty(taskworkBo.getDepartmentId())){//更新研判信息
				iRiskJudgmentTaskService.freshRiskJudgmentTaskwork(taskworkBo.getDepartmentId());
			}
			return CommonResponseUtil.success();
		}
	}

	private void fireRuleByTaskworkStatus(TaskworkBo taskworkBo, ExecuteStateEnum executeStateEnum, String departmentName, String userRealName) {
		try {
			SpcTaskworkRo taskworkRo = new SpcTaskworkRo();
			taskworkRo.setTaskWorkId(String.valueOf(taskworkBo.getId()));
			taskworkRo.setName(taskworkBo.getName());
			taskworkRo.setDeptName(departmentName);
			taskworkRo.setExcuteUserName(userRealName);
			taskworkRo.setViolateState(String.valueOf(taskworkBo.getViolateState()));
			if (taskworkBo.getViolateState().toString().equals(ViolationGradeEnum.无违章.getCode())) {
				taskworkRo.setViolateStateName(ViolationGradeEnum.无违章.getName());
			} else if (taskworkBo.getViolateState().toString().equals(ViolationGradeEnum.一般违章.getCode())) {
				taskworkRo.setViolateStateName(ViolationGradeEnum.一般违章.getName());
			} else if (taskworkBo.getViolateState().toString().equals(ViolationGradeEnum.严重违章.getCode())) {
				taskworkRo.setViolateStateName(ViolationGradeEnum.严重违章.getName());
			}
			if (executeStateEnum.equals(ExecuteStateEnum.通过) || executeStateEnum.equals(ExecuteStateEnum.驳回)) {
				taskworkRo.setExcuteState(executeStateEnum.getCode().toString());
				taskworkRo.setExcuteStateName(executeStateEnum.getName());
				
				if (taskworkBo.getStatus().equals(TaskworkStateEnum.待班组审核.getCode())) {
					taskworkRo.setStatus(TaskworkStateEnum.待班组审核.getCode().toString());
					taskworkRo.setStatusName(TaskworkStateEnum.待班组审核.getName());
				}
				if (taskworkBo.getStatus().equals(TaskworkStateEnum.待车间部门审核.getCode())) {
					taskworkRo.setStatus(TaskworkStateEnum.待车间部门审核.getCode().toString());
					taskworkRo.setStatusName(TaskworkStateEnum.待车间部门审核.getName());
				}
				if (taskworkBo.getStatus().equals(TaskworkStateEnum.待公司审核.getCode())) {
					taskworkRo.setStatus(TaskworkStateEnum.待公司审核.getCode().toString());
					taskworkRo.setStatusName(TaskworkStateEnum.待公司审核.getName());
				}
				if (taskworkBo.getStatus().equals(TaskworkStateEnum.待执行.getCode())) {
					taskworkRo.setStatus(TaskworkStateEnum.待执行.getCode().toString());
					taskworkRo.setStatusName(TaskworkStateEnum.待执行.getName());
				}
				if (taskworkBo.getStatus().equals(TaskworkStateEnum.待确认验收.getCode())) {
					taskworkRo.setStatus(TaskworkStateEnum.待确认验收.getCode().toString());
					taskworkRo.setStatusName(TaskworkStateEnum.待确认验收.getName());
				}
				remoteRuleServer.fireRule(taskworkRo, "weihuaguize/taskWork");
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * 作业活动违章聚合状态更新
	 * 
	 * @param taskworkBo
	 */
	private void updateViolateState(TaskworkBo taskworkBo) {
		List<TaskworkContentBo> contentList = taskworkContentMapper.listByTaskworkId(taskworkBo.getId());
		contentList.forEach(taskworkContent -> {// 1.更新作业活动步骤违章状态
			Long maxViolateState = taskworkMeasuresMapper.getMaxViolateState(taskworkContent.getId());
			if (taskworkContent.getViolateState() < maxViolateState) {
				taskworkContent.setViolateState(maxViolateState);
			}
		});
		taskworkContentMapper.updateBatch(contentList);
		Long maxViolateState = taskworkContentMapper.getMaxViolateState(taskworkBo.getId());
		if (taskworkBo.getViolateState() < maxViolateState) {// 2.更新作业活动违章状态
			taskworkBo.setViolateState(maxViolateState);
		}
		taskworkMapper.update(taskworkBo);
	}

	private void handleAcceptFlowJson(JSONArray contents) {
		if (CollectionUtils.isEmpty(contents)) {
			return;
		}
		List<TaskworkMeasuresBo> measuresBos = Lists.newArrayList();
		for (int i = 0; i < contents.size(); i++) {
			JSONObject content = contents.getJSONObject(i);
			JSONArray taskworkMeasures = content.getJSONArray("taskworkMeasures");
			if (!CollectionUtils.isEmpty(taskworkMeasures)) {
				for (int j = 0; j < taskworkMeasures.size(); j++) {
					JSONObject measure = taskworkMeasures.getJSONObject(j);
					TaskworkMeasuresBo taskworkMeasuresBo = new TaskworkMeasuresBo();
					taskworkMeasuresBo.setId(measure.getLong("id"));
					taskworkMeasuresBo.setViolateState(measure.getInteger("violateState"));
					taskworkMeasuresBo.setRemerk(measure.getString("remark"));
					measuresBos.add(taskworkMeasuresBo);
				}
			}
		}
		if (measuresBos.size() > 0) {
			taskworkMeasuresMapper.updateBatch(measuresBos);
		}
	}

	private void handleExecuteFlowJson(JSONArray contents) {
		List<TaskworkContentBo> contentBos = Lists.newArrayList();
		List<TaskworkMeasuresBo> measuresBos = Lists.newArrayList();
		for (int i = 0; i < contents.size(); i++) {
			JSONObject content = contents.getJSONObject(i);
			String imgs = content.getString("imgs");
			String remark = content.getString("remark");
			if (imgs != null || remark != null) {
				TaskworkContentBo taskworkContentBo = new TaskworkContentBo();
				taskworkContentBo.setId(content.getLong("taskworkContentId"));
				taskworkContentBo.setImg(imgs);
				taskworkContentBo.setRemark(remark);
				contentBos.add(taskworkContentBo);
			}
			JSONArray taskworkMeasures = content.getJSONArray("taskworkMeasures");
			if (!CollectionUtils.isEmpty(taskworkMeasures)) {
				for (int j = 0; j < taskworkMeasures.size(); j++) {
					JSONObject measure = taskworkMeasures.getJSONObject(j);
					TaskworkMeasuresBo taskworkMeasuresBo = new TaskworkMeasuresBo();
					taskworkMeasuresBo.setId(measure.getLong("id"));
					taskworkMeasuresBo.setExecuteState(measure.getInteger("executeState"));
					taskworkMeasuresBo.setRemerk(measure.getString("remark"));
					measuresBos.add(taskworkMeasuresBo);
				}
			}
		}
		if (contentBos.size() > 0) {
			taskworkContentMapper.updateBatch(contentBos);
		}
		if (measuresBos.size() > 0) {
			taskworkMeasuresMapper.updateBatch(measuresBos);
		}
	}

	private TaskworkBo excuteSubmit(String remark, JSONObject flowJson, ExecuteStateEnum executeStateEnum,
			String instanceId, Long taskworkId, TaskworkAuditLogBo currentRecord, String userId,
			String executeUserRealName, String departmentId, String departmentName, String token, String orgCode,
			String taskworkName) {
		JSONObject excuteJson = remoteWorkFlowService.excute(currentRecord.getFlowTaskId(),
				executeStateEnum.getRequestBody(), token);
		if (excuteJson == null) {
			return null;
		}
		TaskworkBo taskworkBo = new TaskworkBo();
		taskworkBo.setId(taskworkId);
		taskworkBo.setUpdateDate(new Date());
		updateFlowRecord(currentRecord, executeStateEnum, userId, departmentId, remark, flowJson);
		JSONObject nextJson = remoteWorkFlowService.currentTask(instanceId, token);
		if (nextJson == null) {
			taskworkBo.setCurrentFlowRecordId(-1L);
			taskworkBo.setStatus(TaskworkStateEnum.完成.getCode());
		} else {
			Set<String> userIds = getUserIdsStrByPerTypeAndDefKey(nextJson);
			String actionFlag = nextJson.getString("taskDefinitionKey");
			TaskworkAuditLogBo record = saveFlowRecord(nextJson.getString("id"), Joiner.on(",").join(userIds),
					nextJson.getString("name"), actionFlag, taskworkId);
			taskworkBo.setCurrentFlowRecordId(record.getId());
			TaskworkStateEnum stateEnum = TaskworkStateEnum.getByActionFlag(actionFlag);
			taskworkBo.setStatus(stateEnum.getCode());
			try {
				String cdate = DateUtil.date2Str(new Date(), DateUtil.DATETIME_DEFAULT_FORMAT);
//				asyncTask.pushTaskworkExecuteMessage(userIds, orgCode, taskworkName, departmentName,
//						executeUserRealName, cdate, currentRecord.getFlowTaskName(), executeStateEnum.getName(),
//						taskworkId, stateEnum.getCode());
			} catch (Exception e) {
				logger.error("作业活动推送给异常", e);
			}
		}
		return taskworkBo;
	}

	private TaskworkAuditLogBo saveFlowRecord(String taskId, String userIds, String taskName, String taskDefinitionKey,
			Long id) {
		TaskworkAuditLogBo record = new TaskworkAuditLogBo();
		record.setTaskworkId(id);
		record.setActionFlag(taskDefinitionKey);
		record.setFlowTaskUserIds(userIds);
		record.setFlowTaskName(taskName);
		record.setFlowTaskId(taskId);
		taskworkAuditLogMapper.save(record);
		return record;
	}

	private void updateFlowRecord(TaskworkAuditLogBo flowRecord, ExecuteStateEnum executeStateEnum, String userId,
			String departmentId, String remark, JSONObject flowJson) {
		flowRecord.setExcuteState(executeStateEnum.getCode());
		flowRecord.setExcuteDepartmentId(departmentId);
		flowRecord.setExcuteUserId(userId);
		flowRecord.setExcuteResult(flowRecord.getFlowTaskName() + executeStateEnum.getName());
		if (!StringUtils.isEmpty(remark)) {
			flowRecord.setRemark(remark);
		}
		if (!StringUtils.isEmpty(flowJson)) {
			flowRecord.setFlowJson(flowJson.toJSONString());
		}
		taskworkAuditLogMapper.update(flowRecord);
	}
	
    private Set<String> getUserIdsStrByPerTypeAndDefKey(JSONObject jsonObject) {
        String taskDefinitionKey = jsonObject.getString("taskDefinitionKey");
        List<UserModel> users = remoteSecurityService.listUserByMenuCode(permissionType, taskDefinitionKey);
        return Sets.newHashSet(Lists.transform(users, UserModel::getUserId));
    }

	@Override
	public CommonResponse listTaskworkContent(Long taskworkId) {
		TaskworkBo taskworkBo = taskworkMapper.getById(taskworkId);
		if (taskworkBo == null) {
			return CommonResponseUtil.failure("作业活动不存在");
		}
		List<UserModel> users = remoteSecurityService.listUserByMenuCode(permissionType, "D_6");
		String ensurePerson = "";
		if (!CollectionUtils.isEmpty(users)) {
			ensurePerson = users.get(0).getRealName();
		}
		List<TaskworkContentBo> contentBos = taskworkContentMapper.listByTaskworkId(taskworkId);
		List<TaskworkContentVo> contentVos = Lists.newArrayList();
		for (TaskworkContentBo contentBo : contentBos) {
			List<TaskworkMeasuresBo> measuresBos = taskworkMeasuresMapper.listByTaskworkContentId(contentBo.getId());
			List<TaskworkMeasureVo> measureVos = Lists.newArrayList();
			if (!CollectionUtils.isEmpty(measuresBos)) {
				for (TaskworkMeasuresBo measuresBo : measuresBos) {
					TaskworkMeasureVo measureVo = new TaskworkMeasureVo();
					measureVo.setExecuteState(measuresBo.getExecuteState());
					measureVo.setId(measuresBo.getId());
					measureVo.setRemark(measuresBo.getRemerk());
					measureVo.setViolateState(measuresBo.getViolateState());
					measureVo.setMeasuresContent(measuresBo.getMeasuresContent());
					measureVo.setEnsurePerson(ensurePerson);
					measureVos.add(measureVo);
				}
			}
			List<RiskFactorBo> riskFactorBos = riskFactorMapper.listTaskworkByTaskworkContentId(contentBo.getId());
			TaskworkContentVo contentVo = new TaskworkContentVo();
			contentVo.setImgs(contentBo.getImg());
			contentVo.setTaskworkContentName(contentBo.getContent());
			contentVo.setTaskworkLevel(contentBo.getRiskLevelName());
			contentVo.setSerialNum(contentBo.getSerialNum());
			contentVo.setTaskworkContentId(contentBo.getId());
			contentVo.setRemark(contentBo.getRemark());
			contentVo.setRiskFactors(riskFactorBos);
			contentVo.setTaskworkMeasures(measureVos);
			contentVos.add(contentVo);
		}
		JSONObject result = new JSONObject();
		result.put("taskworkContents", contentVos);
		return CommonResponseUtil.success(result);
	}

}
