package com.yeejoin.amos.patrol.service.business.service.intfc;

import com.yeejoin.amos.patrol.common.entity.CatalogTree;
import com.yeejoin.amos.patrol.service.business.param.CatalogTreePageParam;
import org.springframework.data.domain.Page;

import java.util.HashMap;
import java.util.List;

public interface ICatalogTreeService {
    /**
     * 树结构查询
     */
    List<Object> getCatalogTree(String orgCode);

    void addCatalogTree(HashMap<String, Object> map);

    void delCatalogTreeById(Long[] param);

    Page<HashMap<String, Object>> getCatalogTreeInfo(String toke,String product,String appKey,CatalogTreePageParam param);

    CatalogTree queryCatalogTreeById(Long id);

    String[] getCataLogList(String loginOrgCode);

    List<CatalogTree> queryCatalogTreeByIds(List<Long> ids);

    List<CatalogTree> getCatalogList(String orgCode);

    /**
     * 根据parentId查询目录列表
     * @param pid
     * @return
     */
    List<CatalogTree> getCatalogListByPid(Long pid, String orgCode);
}
