package com.yeejoin.amos.patrol.service.business.service.intfc;

import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.patrol.common.core.response.AppPointCheckRespone;
import com.yeejoin.amos.patrol.common.core.response.CommonPage;
import com.yeejoin.amos.patrol.common.core.response.GraphInitDataResponse;
import com.yeejoin.amos.patrol.common.core.response.PointCheckInfoRespone;
import com.yeejoin.amos.patrol.common.core.response.QueryCriteriaRespone;
import com.yeejoin.amos.patrol.common.core.response.bo.DepartmentBo;
import com.yeejoin.amos.patrol.common.entity.CheckShot;
import com.yeejoin.amos.patrol.common.entity.UserModel;
import com.yeejoin.amos.patrol.service.business.bo.patrol.CheckDetailBo;
import com.yeejoin.amos.patrol.service.business.bo.patrol.CheckInfoBo;
import com.yeejoin.amos.patrol.service.business.bo.patrol.CheckInputBo;
import com.yeejoin.amos.patrol.service.business.bo.patrol.CheckTraListBo;
import com.yeejoin.amos.patrol.service.business.bo.patrol.CheckUserBo;
import com.yeejoin.amos.patrol.service.business.bo.patrol.PlanRoutePointBo;
import com.yeejoin.amos.patrol.service.business.dto.CheckDto;
import com.yeejoin.amos.patrol.service.business.param.CheckInfoListPageParam;
import com.yeejoin.amos.patrol.service.business.param.CheckInfoPageParam;
import com.yeejoin.amos.patrol.service.business.param.CheckPtListPageParam;
import com.yeejoin.amos.patrol.service.business.param.CheckRecordParam;
import com.yeejoin.amos.patrol.service.business.param.CheckStatisticalParam;
import com.yeejoin.amos.patrol.service.business.util.CheckDetailInputPageParam;
import com.yeejoin.amos.patrol.service.business.vo.CheckAnalysisVo;
import com.yeejoin.amos.patrol.service.business.vo.CheckInfoVo;
//import com.yeejoin.amos.security.common.model.UserModel;

import org.springframework.data.domain.Page;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface ICheckService {
    /**
     * 计划执行记录查询
     *
     * @param param
     * @return
     */
    Page<CheckInfoVo> getCheckInfo(String toke,String product,String appKey,CheckInfoPageParam param);

    void saveCheckImg(CheckShot img);

    CheckDto saveCheckRecord(CheckRecordParam requestParam, AgencyUserModel user, DepartmentBo departmentModel);

    /**
     * 巡检记录删除
     *
     * @param ids
     */
    void delCheckById(List<Long> ids);

    /**
     * 获取检查结果中所有不合格检查项
     *
     * @param checkId
     * @return
     */
    List<Map> queryUnqualifiedInputItem(int checkId);


    /**
     * 检查该店时候已经巡检完成
     *
     * @param requestParam
     * @return
     */
    int checkHasRecord(CheckRecordParam requestParam);

    AppPointCheckRespone queryCheckPointDetail(String toke,String product,String appKey,long checkId);

    /**
     * 巡检统计
     *
     * @param requestParam
     * @return
     */
    Map<String, Object> checkCalendar(CheckRecordParam requestParam);

    /**
     * 根据点ID查询点巡检记录 手机APP
     *
     * @param req
     * @return
     */
    Map<String, Object> queryRecordByPointId(HashMap<String, Object> req);

    /**
     * 查询巡检记录详情
     *
     * @param checkId
     * @return
     */
    Map<String, Object> queryRecordById(int checkId);

    List<CheckInfoVo> getCheckInfoList(String toke,String product,String appKey,CheckInfoPageParam param);

    /**
     * 查询巡检记录所有图片
     *
     * @param param
     * @return
     */
    List<Map<String, Object>> getCheckInfoImgsList(CheckInfoPageParam param);

    /**
     * 根据巡检ID获取图片
     *
     * @param ids
     * @return
     */
    List<Map<String, Object>> getCheckInfoImgsList(Long[] ids);

    /**
     * 根据id获取巡检记录
     *
     * @param ids
     * @return
     */
    List<CheckInfoVo> getSelectedCheckInfoList(String toke,String product,String appKey,Long[] ids);

    /**
     * 本月隐患治理趋势统计
     *
     * @param paramMap
     * @param dateMonth
     * @return
     */
    List<HashMap<String, Object>> getCountMonthChkByRole(HashMap<String, Object> paramMap, String dateMonth);

    /**
     * 风险点信息列表查询条件
     */
    QueryCriteriaRespone getQueryCriteriaInit(String toke,String product,String appKey,String orgCode, String roleTypeName, String departmentId, String companyId);

    List<HashMap<String, String>> getCalCountChkInfo(HashMap<String, Object> paramMap);

    /**
     * 获取用户
     *
     * @param paramsMap
     * @return
     */
    List<CheckUserBo> getAuthUserInfo(HashMap<String, Object> paramsMap);

    /**
     * 根据参数获取巡检记录巡检项
     *
     * @param param
     * @return
     */
    CommonPage<CheckInputBo> getCheckInputByCheckId(CheckDetailInputPageParam param);

    /**
     * 根据巡检记录ID和巡检点ID获取巡检记录详情
     *
     * @param param
     * @return
     */
    CheckDetailBo getCheckDetailById(CheckDetailInputPageParam param);

    /**
     * 根据巡检记录ID获取巡检记录图片信息
     *
     * @param checkID
     * @return
     */
    List<String> getCheckInputPhotoById(Long checkID);

    /**
     * 获取巡检轨迹
     *
     * @param params
     * @return
     */
    Page<CheckTraListBo> getCheckTraList(CheckPtListPageParam params);


    /**
     * 计划路线点最新巡检记录查询
     *
     * @param params
     * @return
     */
    List<PlanRoutePointBo> getRoutePlanPointList(CheckPtListPageParam params);

    /**
     * 根据类型初始化查询条件
     *
     * @param type
     * @return
     */
    QueryCriteriaRespone findCheckSystemInit(String toke,String product,String appKey,String type, String orgCode, String roleTypeName, String departmentId, String companyId);

    /**
     * 巡检记录查询
     *
     * @param params
     * @return
     */
    Page<CheckInfoBo> getCheckInfoList(CheckInfoListPageParam params);

    Page<PointCheckInfoRespone> getCheckInfoList1(CheckInfoListPageParam params);

    /**
     * 视图模块初始化数据
     *
     * @return
     */
    public GraphInitDataResponse getViewModuleInitData();

    /**
     * 巡检情况统计分析
     *
     * @param queryRequests
     * @return
     */
    List<CheckAnalysisVo> getCheckStatisticalAnalysis(String toke,String product,String appKey,CheckStatisticalParam queryRequests);

    /**
     * 根据orgcODE获取巡检累计个数
     *
     * @param loginOrgCode
     * @return
     */
    long getCumulativeCheckCountByOrgCode(String loginOrgCode);

    /**
     * 根据条件查询日巡检统计情况
     *
     * @param param
     * @return
     */
    List<Long> getCheckDataCount(HashMap<String, Object> param);

    List<String> getCheckPhotosByCheckAndInputId(int checkId, int checkInputId);

    List<String> getLivePhotos(Long checkID);

	List<String> getCheckPhotosByCheckAndInputIdAndClassifyId(int checkId, int checkInputId, int classifyId);
}
