package com.yeejoin.amos.patrol.service.business.service.intfc;



import java.io.Serializable;
import java.util.List;

import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;

import com.yeejoin.amos.patrol.common.entity.DaoCriteria;


/**
 * <pre>
 *  JPA基础接口
 * </pre>
 *
 * @author mincx
 * @version IGenericManager.java v0.1
 * @time 2017-9-19 15:43:32
 */
public interface IGenericManager<T, ID extends Serializable> {

    boolean exists(ID id);

    T findOne(ID id);

    T save(T object);

    Iterable<T> save(Iterable<T> entities);

    void delete(T object);

    void delete(ID id);

    List<T> findAll();
    List<T> findAll(Sort sort);
    List<T> findAll(Iterable<ID> ids);
    List<T> findAll(Example<T> example);
    List<T> findAll(Specification<T> spec);
    List<T> findAll(Example<T> example, Sort sort);
    List<T> findAll(Specification<T> spec, Sort sort);

    Page<T> findAll(Pageable pageable);

    Page<T> findAll(Example<T> example, Pageable pageable);

    Page<T> findAll(Specification<T> spec, Pageable pageable);
    /**
	 * <pre>
	 * 根据查询条件查询数据，条件之间用且连接
	 * </pre>
	 * @param daoCriteria
	 * @return List<Equipment>
	 */
	List<T> findAll(List<DaoCriteria> daoCriteria);
	
	/**
	 * <pre>
	 * 根据查询条件查询数据，条件之间用连or接
	 * </pre>
	 * @param daoCriteria
	 * @return List<Equipment>
	 */
	List<T> findAllJoinOR(List<DaoCriteria> daoCriteria);
	/**
	 * <pre>
	 * 根据查询条件和分页查询数据，条件之间用且连接
	 * </pre>
	 * @param daoCriteria
	 * @param pageable
	 * @return Page<Equipment>
	 */
	Page<T> findAll(List<DaoCriteria> daoCriteria,Pageable pageable);
	
	/**
	 * <pre>
	 * 根据查询条件和分页查询数据，条件之间用连or接
	 * </pre>
	 * @param daoCriteria
	 * @param pageable
	 * @return Page<Equipment>
	 */
	Page<T> findAllJoinOR(List<DaoCriteria> daoCriteria,Pageable pageable);

}

