package com.yeejoin.amos.patrol.service.business.service.intfc;

import java.util.List;

import com.yeejoin.amos.patrol.common.entity.DaoCriteria;
import com.yeejoin.amos.patrol.common.entity.InputItem;
import org.springframework.data.domain.Page;

//import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.patrol.service.business.param.InputItemPageParam;
import com.yeejoin.amos.patrol.service.business.vo.InputItemVo;

/**
 * 	检查项业务处理实体
 * @author gaodongdong
 *
 */
public interface IInputItemService {
	/**
	 * 	新增检查项
	 * @param inputItem 检查项
	 * @return
	 */
	public long addNewInputItem(InputItem inputItem);
	
	/**
	 *   	查询检查项详情
	 * @param id
	 * @return
	 */
	public InputItem queryInputItemDetail(Long id);
	
	/**
	 * 	修改检查项
	 * 
	 * @param inputItem 检查项
	 */
	public void updateInputItem(InputItem inputItem);
	
	/**
	 * 	 删除检查项
	 *  
	 * @param id
	 */
	public void delInputItem(Long id);
	
	
	/**
	 * 	分页条件查询检查项
	 * @param criterias
	 * @return
	 */
	public Page<InputItemVo> queryInputItemByPage(InputItemPageParam criterias);
	
	/**
	 * 	条件查询检查项
	 * @param criterias
	 * @return
	 */
	public List<InputItem> queryInputItemByCondition(List<DaoCriteria> criterias);
	
	/**
	 * 	条件查询检查项个数
	 * @return
	 */
	public int queryInputItemCountByCondition(List<DaoCriteria> criterias);

	/**
	 * 另存为
	 * @param ids
	 * @param userId
	 */
	public void saveAs(String[] ids, String userId);

	/**
	 *	 批量删除检查项
	 * @param ids
	 */
	public void batchDelInputItem(String[] ids);

	/**
	 * 获取组织下所有巡检项
	 * @param loginOrgCode
	 * @return
	 */
	public String[] queryInputItemNames(String loginOrgCode);
	
	
	public List<String> qryItemNoList(List<DaoCriteria> criterias, Long itemId);

}
