package com.yeejoin.amos.patrol.service.business.service.intfc;


import com.yeejoin.amos.patrol.common.entity.Msg;
import com.yeejoin.amos.patrol.common.entity.PlanTask;
import com.yeejoin.amos.patrol.common.entity.Task;
import com.yeejoin.amos.patrol.service.business.param.CatalogTreePageParam;
import com.yeejoin.amos.patrol.service.business.param.MsgInfoPageParam;
import com.yeejoin.amos.patrol.service.business.param.NoticePublishParam;
import com.yeejoin.amos.patrol.service.business.vo.MsgVo;
import org.springframework.data.domain.Page;

import java.util.List;
import java.util.Map;

public interface IMessageService {

    /**
     * 巡检消息推送
     */
    public void pushCheckMessage(Long checkId);

    /**
     * 任务消息推送
     *
     * @param task 任务
     */
    public void pushTaskMessage(String toke,String product,String appKey,Task task);

    /**
     * 计划消息推送
     *
     * @param planTask
     * @param jobType
     */
    public void pushPlanTaskMessage(String toke,String product,String appKey,PlanTask planTask, String jobType);


    Page<MsgVo> queryMsgInfoList(MsgInfoPageParam param);

    /**
     * 发布通知消息
     *
     * @param msg
     */
    public List<Msg> publishNotice(String toke,String product,String appKey,NoticePublishParam msg);
    public List<Msg> publishNotice1(String toke,String product,String appKey,NoticePublishParam msg);

    /**
     * 消息公告推送
     *
     * @param msg
     */
    public Msg pushMsg(Msg msg);
    public Msg pushMsg1(Msg msg);

    /**
     * 风险预警推送
     * @param msgMap
     * @return
     */
    public void pushRiskMsg(Map<String, Object> msgMap);
}
