package com.yeejoin.amos.patrol.service.business.service.intfc;

import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
//import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.patrol.common.core.request.CommonPageable;
import com.yeejoin.amos.patrol.common.entity.DaoCriteria;
import com.yeejoin.amos.patrol.common.entity.Msg;
import com.yeejoin.amos.patrol.common.entity.MsgSubscribe;
import com.yeejoin.amos.patrol.common.entity.UserModel;

//import com.yeejoin.amos.security.common.model.UserModel;
import org.springframework.data.domain.Page;

import java.util.List;

public interface IMsgSubscribeService {
	public List<MsgSubscribe> queryMsgSubscribes(String orgCode, String userId);
	
	public List<MsgSubscribe> queryMsgSubscribes(String userId);

	public void saveSubscribe(List<MsgSubscribe> subscribe);
	
	/**
	 * 根据登陆用户获取未读消息数
	 * @param user
	 * @return
	 */
	public int getUnreadCount(AgencyUserModel user);
	
	/**
	 * 根据条件获取用户消息列表
	 * @param criterias
	 * @param commonPageable
	 * @return
	 */
	public Page<Msg> queryMsgList(List<DaoCriteria> criterias, CommonPageable commonPageable);
	
	/**
	 * 修改消息为已读
	 * @param msgId
	 * @return
	 */
	public Msg isRead(long msgId);
}
