package com.yeejoin.amos.patrol.service.business.service.intfc;

import com.yeejoin.amos.patrol.common.entity.CommonResponse;
import com.yeejoin.amos.patrol.common.entity.Plan;
import com.yeejoin.amos.patrol.service.business.param.PlanInfoPageParam;
import org.springframework.data.domain.Page;

import java.util.HashMap;
import java.util.List;

public interface IPlanService {
    /**
     * 巡检计划查询
     *
     * @param param
     * @return
     */
    Page<HashMap<String, Object>> getPlanInfo(PlanInfoPageParam param);

    /**
     * 巡检计划新增及维护
     *
     * @param map
     */
    void addPlan(HashMap<String, Object> map);

    /**
     * 巡检计划删除
     */
    void delPlanById(String[] param);

    /**
     * 巡检计划另存
     */
    void planSaveAs(String[] param);
    /**
     * 巡检路线查询
     */

    /**
     * 根据路线id获取关联的所有计划
     *
     * @param routeId
     * @return
     */
    List<Plan> getPlanByRouteId(Long routeId);

    /**
     * 停用计划
     *
     * @param routeIds
     */
    void disablePlan(Long[] routeIds);

    /**
     * 巡检计划查询
     *
     * @param id
     * @return
     */
    Plan queryPlanById(Long id);

    /**
     * 巡检计划查询,不分页
     *
     * @param param
     * @return
     */
    List<HashMap<String, Object>> getPlanInfoNoPage(PlanInfoPageParam param);

    /**
     * 手机根据登录orgcode查询计划列表
     *
     * @param loginOrgCode
     * @return
     */
    List<HashMap<String, Object>> queryPlanListByOrgCode(String loginOrgCode);
   
    CommonResponse endPlan(List<String> ids);
    
}
