package com.yeejoin.amos.patrol.service.business.service.intfc;

import java.util.List;

import com.yeejoin.amos.patrol.common.entity.CommonResponse;
//import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.patrol.service.business.bo.spc.RiskJudgmentFillRecordBo;
import com.yeejoin.amos.patrol.service.business.param.JdReviewCallBackParam;
import com.yeejoin.amos.patrol.service.business.param.RiskJudgmentSaveRecordParam;

public interface IRiskJudgmentService {

    CommonResponse list(String toke,String product,String appKey,String userId, Integer pageNumber, Integer pageSize, String beginTime, String endTime, Integer status, String orgCode, String deptId);

    /**
     * 根据任务ID和风险研判项类型获取风险研判执行数据
     *
     * @param taskId   任务ID
     * @param itemType 风险研判项类型（1：风险研判表；2：风险研判采集表）
     */
    List<RiskJudgmentFillRecordBo> getRiskJudgmentItemData(Long taskId, Integer itemType, Integer itemLevel, Long itemId);

    /**
     * 保存填写的风险研判表/风险研判信息采集表
     *
     * @param records
     * @param orgCode
     */
    CommonResponse saveRecordInfo(RiskJudgmentSaveRecordParam records, String orgCode, String userId);

    CommonResponse updateTaskStatus(String toke,String product,String appKey,Long taskId, String userId, String token);

    CommonResponse reviewRefuseCallBack(String instanceId, String taskDefinitionKey);

    CommonResponse jdReviewCallBack(String nodeType, JdReviewCallBackParam requestParam, String token);

    CommonResponse detail(String toke,String product,String appKey,Long taskId);

}
