package com.yeejoin.amos.patrol.service.business.service.intfc;

//import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.patrol.service.business.param.RoutePageParam;
import com.yeejoin.amos.patrol.service.business.vo.PointInputItemVo;
import com.yeejoin.amos.patrol.common.core.request.CommonPageable;
import com.yeejoin.amos.patrol.common.core.request.RoutePointInputItemRequest;
import com.yeejoin.amos.patrol.common.core.response.RoutePointRespone;
import com.yeejoin.amos.patrol.common.entity.DaoCriteria;
import com.yeejoin.amos.patrol.common.entity.InputItem;
import com.yeejoin.amos.patrol.common.entity.Plan;
import com.yeejoin.amos.patrol.common.entity.Point;
import com.yeejoin.amos.patrol.common.entity.Route;
import com.yeejoin.amos.patrol.common.entity.RoutePoint;
import org.springframework.data.domain.Page;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public interface IRouteService {

    /**
     * 添加巡检路线
     *
     * @param route
     */
    Route addRoute(Route route);

    /**
     * 删除路线
     *
     * @param routeIds
     */
    void delRouteById(Long[] routeIds);

    /**
     * 更新巡检路线
     *
     * @param route
     */
    Route updateRoute(Route route);

    /**
     * 迁移路线巡检点
     *
     * @param sourceRouteId 当前路线ID
     * @param pointIds      需要迁移的点ID
     * @param targetRouteId 迁移到路线ID
     */
    void migrateRoutePoint(Long sourceRouteId, Long[] pointIds, Long targetRouteId);

    /**
     * 根据点ID查询路线信息
     *
     * @param routeId 路线ID
     */
    Route queryRouteById(Long routeId);

    /**
     * 巡检路线信息查询
     *
     * @param criterias
     * @param commonPageable
     * @return
     */
    Page<Route> queryRouteInfo(List<DaoCriteria> criterias, CommonPageable commonPageable);

    /**
     * 根据条件查询巡检路线列表
     *
     * @param criterias
     * @return
     */
    List<Route> queryRouteInfo(List<DaoCriteria> criterias);

	List<Route> queryRouteList(String orgCode);
    /**
     * 查询巡检路线上点列表
     *
     * @param routeId
     * @param criterias
     * @param commonPageable
     * @return
     */
    Page<Point> queryRoutePoints(Long routeId, List<DaoCriteria> criterias, CommonPageable commonPageable);

    /**
     * 查询路线上点数量
     *
     * @param routeId
     * @return
     */
    int countRoutePoint(Long routeId);

    /**
     * 查询路线上点id
     *
     * @param routeId
     * @return
     */
    List<Long> queryRoutePointIds(Long routeId);

    /**
     * 巡检路线添加巡检点
     *
     * @param routePointList
     */
    void addRoutePoint(List<RoutePoint> routePointList);

    /**
     * 巡检路线删除巡检点
     *
     * @param routeId
     * @param pointIds
     */
    void deleteRoutePoint(Long routeId, Long[] pointIds);

    /**
     * 列出巡检点的巡检项
     *
     * @param routeId
     * @param pointId
     */
    List<PointInputItemVo> listRoutePointInputItem(Long routeId, Long pointId);

    HashMap<String, Object> listRoutePointInputItem(RoutePointInputItemRequest request);

    /**
     * 更新巡检点的巡检项
     *
     * @param routeId
     * @param pointId
     */
    void updateRoutePointInputItem(Long routeId, Long pointId, Long[] inputItemIds);

    /**
     * 列出巡检点的巡检项及其分类
     *
     * @param routeId
     * @param pointId
     */
    Map<String, List<InputItem>> listRoutePointInputItemWithClassify(Long routeId, Long pointId);

    /**
     * 根据参数获取路线信息列表
     *
     * @param param
     * @return
     */
    Page<HashMap<String, Object>> getRouteInfo(RoutePageParam param);

    /**
     * 计划查询
     *
     * @param id
     * @return
     */
    List<Plan> queryPlanByRouteId(long id);

    /**
     * 根据组织编码查询所有巡检路线
     *
     * @param orgCode
     * @return
     */
    List<HashMap<String, Object>> queryRouteListByOrgCode(String orgCode, String userId, String deptId);

    /**
     * 根据路线查询巡检点
     *
     * @param routeId
     * @param reqParam
     * @param commonPageable
     * @return
     */
    Page<RoutePointRespone> queryRoutePoints(Long routeId, HashMap<String, Object> reqParam,
                                             CommonPageable commonPageable);

    /**
     * 交换路线巡检点排序序号
     *
     * @param src
     * @param target
     */
    void exchangeRoutePointOrderNumber(long src, long target);

    /**
     * 获取路线下所有点id
     *
     * @param routeID
     * @return
     */
    List<Long> getPointIDByRouyeId(Long routeID);

    /**
     * 根据路线ID获取对应路线下的点
     *
     * @param routeIds
     * @return
     */
    LinkedHashMap<String, Object> getPointIdByRouteId(List<String> routeIds);

    /**
     * 判断巡检路线是否重复
     *
     * @param orgCode
     * @param name
     * @return
     */
    boolean existRouteName(String orgCode, String name);

}
