package com.yeejoin.amos.patrol.service.business.service.intfc;

import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.patrol.common.entity.DaoCriteria;
//import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.patrol.common.entity.Task;
import com.yeejoin.amos.patrol.common.entity.TaskFeedback;
import com.yeejoin.amos.patrol.common.entity.TaskPicture;
import com.yeejoin.amos.patrol.common.entity.UserModel;
import com.yeejoin.amos.patrol.service.business.bo.patrol.TaskBo;
import com.yeejoin.amos.patrol.service.business.param.TaskPageParam;
import com.yeejoin.amos.patrol.service.business.param.TaskParam;
import com.yeejoin.amos.patrol.service.business.param.TaskStatisticsParam;
import com.yeejoin.amos.patrol.service.business.vo.TaskStatisticsVo;
//import com.yeejoin.amos.security.common.model.UserModel;
import org.quartz.JobDataMap;
import org.springframework.data.domain.Page;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 巡检任务业务处理接口
 *
 * @author gaodongdong
 */
public interface ITaskService {

    /**
     * 新增任务
     */
    Long addNewTask(TaskParam param);

    /**
     * 查询任务详情
     */
    TaskBo queryTaskDetail(Long taskID);

    /**
     * 修改任务
     */
    void updateTask(TaskParam param);

    /**
     * 删除任务
     */
    void delTask(Long taskID);

    /**
     * 回复任务
     */
    Task feedbackTask(TaskFeedback taskFeedback, List<TaskPicture> pictures);

    /**
     * 转发任务
     */
    void forwardTask(String toke,String product,String appKey,Long taskId, AgencyUserModel user, String targetUserId) throws Exception;

    /**
     * 分页条件查询任务
     */
    Page<HashMap<String, Object>> queryTaskByPage(TaskPageParam param);

    /**
     * 条件查询任务
     */
    List<Task> queryTaskByCondition(List<DaoCriteria> criterias);

    /**
     * 条件查询任务个数
     */
    int queryTaskCountByCondition(List<DaoCriteria> criterias);

    /**
     * 批量删除任务
     */
    void batchDelTask(String taskIDs);

    /**
     * 跟新任务状态
     */
    void handleTask(String taskIds, int status, AgencyUserModel user, String orgCode);

    /**
     * 手机app获取任务图表数据
     */
    Map queryTaskCharts(HashMap<String, Object> request);


    String job(JobDataMap jobDataMap);

    /**
     * 手机根据条件查询任务
     */
    List<Map> queryTasks(HashMap<String, Object> request);

    HashMap<String, List<HashMap<String, Object>>> getHiddenDangerCountData(HashMap<String, Object> params);


    /**
     * 根据巡检路线IDs获取对应路线上的所有点ID
     */
    List<HashMap<String, Object>> getPointIDsByRouteIDs(List<String> routeID);

    Map<String, Object> getTaskForAppPie(HashMap<String, Object> params);

    /**
     * 根据条件统计任务
     */
    List<TaskStatisticsVo> getTaskStatistics(TaskStatisticsParam param);

    /**
     * 获取公司任务完成情况
     */
    String getTaskFinishCountByOrgCode(String loginOrgCode);


    List<TaskFeedback> queryTaskRecord(Long taskID);

    /**
     * 查询检查项不合格任务详情
     */
    Map<String, Object> queryCheckTaskDetail(long checkId, long taskId);

    /**
     * 同步手机离线任务
     */
    List<Map<String, Object>> synchronizedOfflineTasks(String userId);
}
