package com.yeejoin.amos.patrol.service.business.util;

import java.text.SimpleDateFormat;
import java.util.List;

import com.yeejoin.amos.patrol.common.entity.DaoCriteria;
//import com.yeejoin.amos.op.core.common.query.DaoCriteria;
import com.yeejoin.amos.patrol.service.business.param.CheckRecordParam;
import com.yeejoin.amos.patrol.service.core.enums.QueryOperatorEnum;
import com.yeejoin.amos.patrol.service.business.param.CheckRecordParam;

public class CheckParamUtil {

	public static CheckRecordParam checkCalendar(List<DaoCriteria> daoCriterias){
		CheckRecordParam param = new CheckRecordParam();
		for(int i=0;i<daoCriterias.size();i++){
			DaoCriteria daoCriteria = daoCriterias.get(i);
			String operator = daoCriteria.getOperator();
			String name = daoCriteria.getPropertyName();
			if("checkTime".equals(name)){
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
				param.setCheckTime(daoCriterias.get(i).getValue().toString());
			}else if("userId".equals(name)){
				param.setUserId(daoCriterias.get(i).getValue().toString());
			}else if("routeId".equals(name)){
				param.setRouteId(Long.valueOf(daoCriterias.get(i).getValue().toString()));
			}else if("orgCode".equals(name) && operator.equals(QueryOperatorEnum.EQUAL.getName())){
				param.setOrgCode(daoCriterias.get(i).getValue().toString());
			}
		}		
		return param;
		
	}
}
