package com.yeejoin.amos.patrol.service.business.util;

import java.util.HashMap;
import java.util.List;

import com.yeejoin.amos.patrol.service.business.param.InputItemPageParam;
import com.yeejoin.amos.patrol.common.core.request.CommonPageable;
import com.yeejoin.amos.patrol.common.core.request.CommonRequest;
import com.yeejoin.amos.patrol.common.entity.InputItem;
import org.springframework.util.ObjectUtils;

public class InputItemParamUtil {

	public static InputItem fillInputItemInfo(List<CommonRequest> queryRequests) {
		InputItem inputItem = new InputItem();
		if (ObjectUtils.isEmpty(queryRequests)) {
			return inputItem;
		}
		for (CommonRequest request : queryRequests) {
			if ("name".equals(request.getName())) {
				inputItem.setName(request.getValue().toString());
			} else if ("itemType".equals(request.getName())) {
				inputItem.setItemType(request.getValue().toString());
			} else if ("isScore".equals(request.getName())) {
				inputItem.setIsScore(request.getValue().toString());
			}else if ("level".equals(request.getName())) {
				inputItem.setLevel(request.getValue().toString());
				}
		}
		return inputItem;
	}
	
	public static InputItemPageParam fillInputItemPageParam(List<CommonRequest> queryRequests, CommonPageable commonPageable,
                                                            HashMap<String, Object> perMap) {
		InputItemPageParam param = new InputItemPageParam();	
		for(int i=0;i<queryRequests.size();i++){
			String name = queryRequests.get(i).getName();
			if("name".equals(name)){
				param.setName(toString(queryRequests.get(i).getValue()));
			}else if("itemType".equals(name)){
				param.setItemType(toString(queryRequests.get(i).getValue()));
			}else if("isScore".equals(name)){
				param.setIsScore(toString(queryRequests.get(i).getValue()));
			} else if("catalogId".equals(name)){
				param.setCatalogId(Integer.parseInt(toString(queryRequests.get(i).getValue())));
			}else if("level".equals(name)){
				param.setLevel(toString(queryRequests.get(i).getValue()));
			}else if("itemNo".equals(name)){
				param.setItemNo(toString(queryRequests.get(i).getValue()));
			}		
		}
		param.setOrgCode(perMap.get("orgCode").toString());
		if(commonPageable !=null){
			param.setPageNumber(commonPageable.getPageNumber());
			param.setPageSize(commonPageable.getPageSize());	
		}
		return param;
		
	}
		private static String toString(Object value) {
			if(null ==value || value ==""){
				return null;
			}else{
				return value.toString();
			}		
		}

}
