package com.yeejoin.amos.patrol.service.business.util;

import java.util.HashMap;
import java.util.List;

import com.yeejoin.amos.patrol.service.business.param.PlanInfoPageParam;
import com.yeejoin.amos.patrol.common.core.request.CommonPageable;
import com.yeejoin.amos.patrol.common.core.request.CommonRequest;

public class PlanPageParamUtil {

	public static PlanInfoPageParam fillPlanInfoParam(List<CommonRequest> queryRequests, CommonPageable commonPageable,
                                                      HashMap<String, Object> perMap) {
		PlanInfoPageParam param = new PlanInfoPageParam();
		for(int i=0;i<queryRequests.size();i++){
			String name = queryRequests.get(i).getName();
			if("name".equals(name)){
				param.setPlanName(toString(queryRequests.get(i).getValue()));
			}else if("planType".equals(name)){
				param.setPlanType(toString(queryRequests.get(i).getValue()));
			}else if("routeId".equals(name)){
				param.setRouteId(toString(queryRequests.get(i).getValue()));
			}else if("remark".equals(name)){
				param.setRemark(toString(queryRequests.get(i).getValue()));
			}
		}		
		param.setOrgCode(perMap.get("orgCode") == null ? null:perMap.get("orgCode").toString());
		param.setUserId(perMap.get("userId") == null ? null:perMap.get("userId").toString());
		if(commonPageable !=null){
			param.setPageNumber(commonPageable.getPageNumber());
			param.setPageSize(commonPageable.getPageSize());	
		}
		return param;
	}
	
	private static String toString(Object value) {
		if(null ==value || value ==""){
			return null;
		}else{
			return value.toString();
		}		
	}

}
