package com.yeejoin.amos.patrol.service.core.async;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.DepartmentModel;
//import com.yeejoin.amos.op.core.util.StringUtil;
import com.yeejoin.amos.patrol.common.core.response.bo.DepartmentBo;
import com.yeejoin.amos.patrol.common.entity.Check;
import com.yeejoin.amos.patrol.common.entity.Msg;
import com.yeejoin.amos.patrol.common.entity.PlanTask;
import com.yeejoin.amos.patrol.common.entity.StringUtil;
import com.yeejoin.amos.patrol.common.entity.UserModel;
import com.yeejoin.amos.patrol.common.enums.CheckStatusEnum;
import com.yeejoin.amos.patrol.common.enums.JPushTypeEnum;
import com.yeejoin.amos.patrol.common.enums.MsgSubscribeTypeEnum;
import com.yeejoin.amos.patrol.common.enums.PlanTaskDetailIsFinishEnum;
import com.yeejoin.amos.patrol.common.enums.PlanTaskFinishStatusEnum;
import com.yeejoin.amos.patrol.service.business.bo.patrol.CheckPointBo;
import com.yeejoin.amos.patrol.service.business.bo.patrol.MsgSubscribeBo;
import com.yeejoin.amos.patrol.service.business.bo.patrol.TaskMsgBo;
import com.yeejoin.amos.patrol.service.business.dao.mapper.MsgMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.MsgSubscribeMapper;
import com.yeejoin.amos.patrol.service.business.dao.repository.ICheckDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.ICheckInputDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IMsgDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IPlanTaskDetailDao;
import com.yeejoin.amos.patrol.service.business.param.PushMsgParam;
import com.yeejoin.amos.patrol.service.business.service.intfc.IMessageService;
import com.yeejoin.amos.patrol.service.business.service.intfc.ISafety3DDataSendService;
import com.yeejoin.amos.patrol.service.business.util.CacheFactory;
import com.yeejoin.amos.patrol.service.business.util.CacheMap;
import com.yeejoin.amos.patrol.service.business.util.Toke;
import com.yeejoin.amos.patrol.service.constants.XJConstant;
import com.yeejoin.amos.patrol.service.core.util.DateUtil;
import com.yeejoin.amos.patrol.service.email.EmailServiceImpl;
import com.yeejoin.amos.patrol.service.email.IEmailService;
import com.yeejoin.amos.patrol.service.jpush.AppMessagePushService;
import com.yeejoin.amos.patrol.service.remote.RemoteSecurityService;
import com.yeejoin.amos.patrol.service.websocket.AmosWsClient;
import com.yeejoin.amos.patrol.service.websocket.WebsocketParam;
//import com.yeejoin.amos.security.common.model.UserModel;

/**
 * 异步执行任务
 *
 * @author Administrator
 */
@Component
public class AsyncTask {


    private final Logger log = LoggerFactory.getLogger(EmailServiceImpl.class);
    //
//	@Autowired
//	private IEmailService iEmailService;

    @Autowired
    private MsgMapper msgMapper;

    @Autowired
    private AppMessagePushService appMessagePushService;

    @Autowired
    private ISafety3DDataSendService safety3DDataSend;

    @Autowired
    private IMessageService messageService;

    @Autowired
    private MsgSubscribeMapper msgSubscribeMapper;

    @Autowired
    private RemoteSecurityService remoteSecurityService;

    @Autowired
    private IEmailService iEmailService;

    @Autowired
    private IMsgDao iMsgDao;
    
    @Autowired
    private ICheckInputDao iCheckInputDao;

    @Autowired
    private ICheckDao iCheckDao;
    
    @Autowired
    private IPlanTaskDetailDao planTaskDetailDao;
    
    @Autowired
    private AmosWsClient client;

    private static final String TAB = "\r\n";
    private static final String TOKE = "TOKE";

    /**
     * 邮件发送
     * @param msgResponse
     * @return
     * @throws InterruptedException
     */
//	@Async("asyncTaskExecutor")
//	public Future<Boolean> sendEmail(PushMsgParam pmp) throws InterruptedException {
//		  	long start = System.currentTimeMillis();
//	        iEmailService.sendSimpleEmail(pmp.getEmails(), pmp.getSubject(), pmp.getContent());
//	        long end = System.currentTimeMillis();
//	        log.info("=====邮件发送耗时："+(end-start)+"======");
//	        return new AsyncResult<Boolean>(true);
//	}
//	
//	/**
//	 * jpush 推送
//	 * @param pmps
//	 * @return
//	 * @throws InterruptedException
//	 */
//	@Async("asyncTaskExecutor")
//    public Future<Boolean> sendJpush(List<PushMsgParam> pmps) throws InterruptedException {
//        long start = System.currentTimeMillis();
//        appMessagePushService.sendMessage(pmps);
//        long end = System.currentTimeMillis();
//        //返回true，告诉此任务已完成
//        log.info("=====Jpush发送耗时："+(end-start)+"======");
//        return new AsyncResult<Boolean>(true);
//    }

    /**
     * 检查消息推送
     *
     * @param checkId
     * @return
     * @throws InterruptedException
     */
    @Async("asyncTaskExecutor")
    public Future<Boolean> pushCheckInfoTo3D(Long checkId) throws InterruptedException {
        //获取缓存
        CacheMap cacheMap= CacheFactory.newChacheMap();
        Toke  toke=  cacheMap.getValue(TOKE);
        if(toke==null){
        	toke= remoteSecurityService.come();
        	Long times=  (long) (20*24*60*60);
        	cacheMap.setex(TOKE, toke, times);
        }
        //巡检结果推送至业务
        safety3DDataSend.pointCheckInfoPushToB(toke.getToke(),toke.getProduct(),toke.getAppKey(),checkId);
        safety3DDataSend.pointCheckInfoPush(toke.getToke(),toke.getProduct(),toke.getAppKey(),checkId);
        return new AsyncResult<Boolean>(true);
    }

    /**
     * 项业务系统推送检查结果信息
     *
     * @param checkId
     * @return
     * @throws InterruptedException
     */
    @Async("asyncTaskExecutor")
    public Future<Boolean> pushSpcCheckResult(Long checkId) throws InterruptedException {
    	//获取缓存
        CacheMap cacheMap= CacheFactory.newChacheMap();
        Toke  toke=  cacheMap.getValue(TOKE);
        if(toke==null){
        	toke= remoteSecurityService.come();
        	Long times=  (long) (20*24*60*60);
        	cacheMap.setex(TOKE, toke, times);
        }
       
    	
    	safety3DDataSend.pushSpcCheckResult(toke.getToke(),toke.getProduct(),toke.getAppKey(),checkId);
        return new AsyncResult<Boolean>(true);
    }

    /**
     * 任务推送
     *
     * @param taskId
     * @return
     * @throws InterruptedException
     */
    @Async("asyncTaskExecutor")
    public Future<Boolean> pushTaskDetailInfoTo3D(Long taskId) throws InterruptedException {
        safety3DDataSend.taskDetailInfoPush(taskId);
        return new AsyncResult<Boolean>(true);
    }

    @Async("asyncTaskExecutor")
    public Future<Boolean> pushPointTo3D(List<Long> pointIds) throws InterruptedException {
        safety3DDataSend.pushPointTo3D(pointIds);
        return new AsyncResult<Boolean>(true);
    }

    @Async("asyncTaskExecutor")
    public Future<Boolean> pushDeletePointTo3D(List<Long> pointIds) throws InterruptedException {
        safety3DDataSend.pushPointTo3D(pointIds);
        return new AsyncResult<Boolean>(true);
    }

    @Async("asyncTaskExecutor")
    public Future<Boolean> pushRouteTo3D(List<Long> routeIds) throws InterruptedException {
        safety3DDataSend.pushRouteInfoTo3D(routeIds);
        return new AsyncResult<Boolean>(true);
    }

    @Async("asyncTaskExecutor")
    public Future<Boolean> pushCheckMessage(Long checkId) throws InterruptedException {
        messageService.pushCheckMessage(checkId);
        return new AsyncResult<Boolean>(true);
    }

    /**
     * 隐患治理
     */
    @Async("asyncTaskExecutor")
    public void pushLatentDangerExecuteMessage(Set<String> sendUserIds, String orgCode,
                                               String latentDangerName, String pointName,
                                               String exeDeptName, Long latentDangerId,
                                               String exeUserRealName, String flowName,
                                               String flowResult, String executeDate,
                                               Integer state) {
        if (CollectionUtils.isEmpty(sendUserIds)) {
            return;
        }
        MsgSubscribeTypeEnum msgTypeEnum = MsgSubscribeTypeEnum.隐患治理推送;
        String body = "";
        body += executeDate + TAB;
        body += exeDeptName + " " + exeUserRealName + " " + flowName + "：" + flowResult + TAB;
        body += "隐患名称：" + latentDangerName + TAB;
        if (pointName != null) {
            body += "关联检查点：" + pointName + TAB;
        }
        saveAndSendMsg(orgCode, sendUserIds, msgTypeEnum.getTitle(), body, msgTypeEnum.getMsgType(), latentDangerId, state);
    }

    /**
     * 隐患验证通过
     */
    @Async("asyncTaskExecutor")
    public void pushRiskWarnMessage(Set<String> sendUserIds, String orgCode,
                                    String latentDangerName, Long riskFactorId,
                                    String riskFactorName, String pointName,
                                    String executeDate) {
        if (CollectionUtils.isEmpty(sendUserIds)) {
            return;
        }
        MsgSubscribeTypeEnum msgTypeEnum = MsgSubscribeTypeEnum.风险评价提醒推送;
        String body = "";
        body += latentDangerName + "管控措施失效，隐患治理验证完毕,需重新进行风险评价！" + TAB;
        body += "关联危险源：" + pointName + TAB;
        body += "关联危险因素：" + riskFactorName + TAB;
        body += "执行时间：" + executeDate + TAB;
        if (pointName != null) {
            body += "关联检查点：" + pointName + TAB;
        }
        saveAndSendMsg(orgCode, sendUserIds, msgTypeEnum.getTitle(), body, msgTypeEnum.getMsgType(), riskFactorId, null);
    }

    
    
    
    
    
    
					    private void saveAndSendMsg(String orgCode, Set<String> sendUserIds,
					            String title, String body, String msgType,
					            Long relationId, Integer state,String xid,String pid) {
					if (!CollectionUtils.isEmpty(sendUserIds)) {
					Date date = new Date();
					List<Msg> msgs = Lists.newArrayList();
					//获取缓存
		            CacheMap cacheMap= CacheFactory.newChacheMap();
		            Toke  toke=  cacheMap.getValue(TOKE);
		            if(toke==null){
		            	toke= remoteSecurityService.come();
		            	Long times=  (long) (20*24*60*60);
		            	cacheMap.setex(TOKE, toke, times);
		            }
					for (String sendUserId : sendUserIds) {
					Msg msg = new Msg();
					msg.setOrgCode(orgCode);
					msg.setUserId(sendUserId);
					msg.setCreateBy(sendUserId);
					msg.setTitle(title);
					msg.setBody(body);
					msg.setMsgType(msgType);
					msg.setRelationId(relationId);
					msg.setIsImmediately(true);
					msg.setSendTime(date);
					msg.setCreateDate(date);
		            List<AgencyUserModel> userModels = remoteSecurityService.listUserByUserIds(toke.getToke(),toke.getProduct(),toke.getAppKey(),sendUserId);
                    if(userModels!=null&&userModels.size()>0){
    					msg.setReciverName(userModels.get(0).getRealName());

                    }
					
					msgs.add(msg);
					
					
					}
					Map<String, String> extras = Maps.newHashMap();
					extras.put("type", msgType);
					extras.put("id", String.valueOf(relationId)); 
					extras.put("pointId",pid ); 
					extras.put("planTaskId", xid); 
					
					if (state != null) {
					extras.put("state", String.valueOf(state));
					}
					PushMsgParam pushMsgParam = new PushMsgParam();
					pushMsgParam.setContent(body);
					pushMsgParam.setRecivers(Lists.newArrayList(sendUserIds));
					pushMsgParam.setSubject(title);
					pushMsgParam.setType(JPushTypeEnum.ALIAS.getCode());
					pushMsgParam.setExtras(extras);
					iMsgDao.saveAll(msgs);
					//appMessagePushService.sendMessage(pushMsgParam);
					appMessagePushService.pushNoticeMany(pushMsgParam);
					log.info("极光推送成功====>" + sendUserIds);
					}
					}

    
   
    
    
    private void saveAndSendMsg(String orgCode, Set<String> sendUserIds,
                                String title, String body, String msgType,
                                Long relationId, Integer state) {
        if (!CollectionUtils.isEmpty(sendUserIds)) {
            Date date = new Date();
            List<Msg> msgs = Lists.newArrayList();
          //获取缓存
            CacheMap cacheMap= CacheFactory.newChacheMap();
            Toke  toke=  cacheMap.getValue(TOKE);
            if(toke==null){
            	toke= remoteSecurityService.come();
            	Long times=  (long) (20*24*60*60);
            	cacheMap.setex(TOKE, toke, times);
            }
            for (String sendUserId : sendUserIds) {
                Msg msg = new Msg();
                msg.setOrgCode(orgCode);
                msg.setUserId(sendUserId);
                msg.setCreateBy(sendUserId);
                msg.setTitle(title);
                msg.setBody(body);
                msg.setMsgType(msgType);
                msg.setRelationId(relationId);
                msg.setIsImmediately(true);
                msg.setSendTime(date);
                msg.setCreateDate(date);
                List<AgencyUserModel> userModels = remoteSecurityService.listUserByUserIds(toke.getToke(),toke.getProduct(),toke.getAppKey(),sendUserId);
                if(userModels!=null&&userModels.size()>0){
					msg.setReciverName(userModels.get(0).getRealName());

                }
                msgs.add(msg);
            }
            Map<String, String> extras = Maps.newHashMap();
            extras.put("type", msgType);
            extras.put("id", String.valueOf(relationId));
            if (state != null) {
                extras.put("state", String.valueOf(state));
            }
            PushMsgParam pushMsgParam = new PushMsgParam();
            pushMsgParam.setContent(body);
            pushMsgParam.setRecivers(Lists.newArrayList(sendUserIds));
            pushMsgParam.setSubject(title);
            pushMsgParam.setType(JPushTypeEnum.ALIAS.getCode());
            pushMsgParam.setExtras(extras);
            iMsgDao.saveAll(msgs);
            //appMessagePushService.sendMessage(pushMsgParam);
            appMessagePushService.pushNoticeMany(pushMsgParam);
            log.info("极光推送成功====>" + sendUserIds);
        }
    }

    /**
     * 风险研判
     */
//    @Async("asyncTaskExecutor")
//    public void pushRiskJudgmentMessage(Set<String> sendUserIds, String orgCode,
//                                        String riskJudgmentName, String dataStr,
//                                        String departmentName, String statusDesc,
//                                        Long taskId, Integer state) {
//        if (CollectionUtils.isEmpty(sendUserIds)) {
//            return;
//        }
//        MsgSubscribeTypeEnum msgTypeEnum = MsgSubscribeTypeEnum.风险研判推送;
//        String body = "";
//        body += riskJudgmentName + "：" + dataStr + TAB;
//        body += departmentName + TAB;
//        body += "状态：" + statusDesc + TAB;
//        saveAndSendMsg(orgCode, sendUserIds, msgTypeEnum.getTitle(), body, msgTypeEnum.getMsgType(), taskId, state);
//        MsgSubscribeTypeEnum eamilMsgTypeEnum = MsgSubscribeTypeEnum.推送风险研判消息;
//        Set<String> emailAfterFilterUserIds = userIdFilter(sendUserIds, eamilMsgTypeEnum.getMsgType());
//        sendEmail(emailAfterFilterUserIds, msgTypeEnum.getTitle(), body);
//    }

    private void sendEmail(Set<String> emailAfterFilterUserIds, String title, String body) {
        if (!CollectionUtils.isEmpty(emailAfterFilterUserIds)) {
        	//获取缓存
            CacheMap cacheMap= CacheFactory.newChacheMap();
            Toke  toke=  cacheMap.getValue(TOKE);
            if(toke==null){
            	toke= remoteSecurityService.come();
            	Long times=  (long) (20*24*60*60);
            	cacheMap.setex(TOKE, toke, times);
            }
           
            List<AgencyUserModel> userModels = remoteSecurityService.listUserByUserIds(toke.getToke(),toke.getProduct(),toke.getAppKey(),Joiner.on(",").join(emailAfterFilterUserIds));
            List<String> emailList = Lists.newArrayList();
            for (AgencyUserModel user : userModels) {
                if (!StringUtils.isEmpty(user.getEmail())) {
                    emailList.add(user.getEmail());
                }
            }
            String[] emailArr = new String[emailList.size()];
            emailList.toArray(emailArr);
            iEmailService.sendSimpleEmail(emailArr, title, body);
            log.info("邮箱推送成功====>" + emailList);
        }
    }

    private Set<String> userIdFilter(Set<String> sendUserIds, String msgType) {
        Set<String> afterFilterUserIds = Sets.newHashSet();
        if (CollectionUtils.isEmpty(sendUserIds)) {
            return afterFilterUserIds;
        }
        List<MsgSubscribeBo> msgSubscribeList = msgSubscribeMapper.listMsgSubscribeByTypeAndUserIds(msgType, sendUserIds);
        if (CollectionUtils.isEmpty(msgSubscribeList)) {
            return afterFilterUserIds;
        }
        Map<String, MsgSubscribeBo> msgSubscribeMap = Maps.uniqueIndex(msgSubscribeList, MsgSubscribeBo::getUserId);
        for (String userId : sendUserIds) {
            MsgSubscribeBo m = msgSubscribeMap.get(userId);
            if (m != null && m.getAttribute1().equals("True")) {
                afterFilterUserIds.add(m.getUserId());
            }
        }
        return afterFilterUserIds;
    }

    /**
     * 作业活动
     */
//    @Async("asyncTaskExecutor")
//    public void pushTaskworkExecuteMessage(Set<String> sendUserIds, String orgCode,
//                                           String taskworkName, String exeDeptName,
//                                           String exeUserRealName, String executeDate,
//                                           String flowName, String flowResult,
//                                           Long taskworkId, Integer state) {
//        if (CollectionUtils.isEmpty(sendUserIds)) {
//            return;
//        }
//        MsgSubscribeTypeEnum msgTypeEnum = MsgSubscribeTypeEnum.作业活动推送;
//        String body = "";
//        body += executeDate + TAB;
//        body += exeDeptName + " " + exeUserRealName + " " + flowName + "：" + flowResult + TAB;
//        body += "作业活动名称：" + taskworkName + TAB;
//        saveAndSendMsg(orgCode, sendUserIds, msgTypeEnum.getTitle(), body, msgTypeEnum.getMsgType(), taskworkId, state);
//        MsgSubscribeTypeEnum eamilMsgTypeEnum = MsgSubscribeTypeEnum.推送作业活动消息;
//        Set<String> emailAfterFilterUserIds = userIdFilter(sendUserIds, eamilMsgTypeEnum.getMsgType());
//        sendEmail(emailAfterFilterUserIds, msgTypeEnum.getTitle(), body);
//    }

    /**
     * 隐患排查：有记录就推送
     * @param map 
     */
    @Async("asyncTaskExecutor")
    public void pushCheckRecordMessage(Long checkId, String userName, HashMap<String, Object> map) {
        CheckPointBo checkPointBo = msgMapper.getPointInfo(checkId);
        if (checkPointBo == null) {
            return;
        }
        
        
        
//        Set<String> userIds = msgMapper.getPointLeaderUserId(map);
//        if (CollectionUtils.isEmpty(userIds)) {
//            return;
//        }
        
               Set<String> userIds=new HashSet<>();
              //查询当前点的责任人1547041
                String   id=  "".equals(map.get("pointId")+"")?null:(map.get("pointId")+"");
               Map<String, String> mapi=  msgMapper.getuserid(id);
               if(mapi!=null&&!mapi.isEmpty()){
            	String  ids=   mapi.get("charge_person_id");
            	String[] idg=ids.split(",");
            
            	
            	for (int i = 0; i < idg.length; i++) {
            		userIds.add(idg[i]);
				}
            	
            	
               }else{
            	   return ;
               }
        
        
        
        MsgSubscribeTypeEnum eamilMsgTypeEnum = MsgSubscribeTypeEnum.推送检查记录消息;
        //有检查记录推送
        MsgSubscribeTypeEnum haveRecordMsgTypeEnum = MsgSubscribeTypeEnum.有检查记录推送;
        Set<String> haveRecordUserIds = userIdFilter(userIds, haveRecordMsgTypeEnum.getMsgType());
        String havaRecordBody = "";
        havaRecordBody += "巡检时间：" +DateUtil.formatDatrToStr(checkPointBo.getCheckTime(), DateUtil.LONG_PATTERN) + TAB;
        havaRecordBody += "巡检人员：" + userName + TAB;
        havaRecordBody += "点编号：" + checkPointBo.getPointNo() + TAB;
        havaRecordBody += "巡检点名称：" + checkPointBo.getPointName() + TAB;
        havaRecordBody += "当前状态：" +CheckStatusEnum.getEnum(checkPointBo.getState()).getName() + TAB;
        if("异常".equals(CheckStatusEnum.getEnum(checkPointBo.getState()).getName())){
            havaRecordBody += "异常项：" + checkPointBo.getErrorItem() + TAB;

        }
        
        
        saveAndSendMsg(checkPointBo.getOrgCode(), haveRecordUserIds, haveRecordMsgTypeEnum.getTitle(), havaRecordBody, haveRecordMsgTypeEnum.getMsgType(), checkId, null);
        Set<String> haveRecordemailAfterFilterUserIds = userIdFilter(haveRecordUserIds, eamilMsgTypeEnum.getMsgType());
        sendEmail(haveRecordemailAfterFilterUserIds, haveRecordMsgTypeEnum.getTitle(), havaRecordBody);
    }

    /**
     * 隐患排查：不合格推送
     * @param map 
     */
    @Async("asyncTaskExecutor")
    public void pushNoPassCheckRecordMessage(Long checkId, String userName, HashMap<String, Object> map) {
        CheckPointBo checkPointBo = msgMapper.getPointInfo(checkId);
        if (checkPointBo == null) {
            return;
        }
//        Set<String> userIds = msgMapper.getPointLeaderUserId(map);
//        if (CollectionUtils.isEmpty(userIds)) {
//            return;
//        }
        
        
        Set<String> userIds=new HashSet<>();
        //查询当前点的责任人
          String   id=  "".equals(map.get("pointId")+"")?null:(map.get("pointId")+"");
         Map<String, String> mapi=  msgMapper.getuserid(id);
         if(mapi!=null&&!mapi.isEmpty()){
      	String  ids=   mapi.get("charge_person_id");
      	String[] idg=ids.split(",");
      
      	
      	for (int i = 0; i < idg.length; i++) {
      		userIds.add(idg[i]);
			}
      	
      	
         }else{
      	   return ;
         }
        
        
        
        MsgSubscribeTypeEnum eamilMsgTypeEnum = MsgSubscribeTypeEnum.推送检查记录消息;
        //不合格推送
        MsgSubscribeTypeEnum noPassMsgTypeEnum = MsgSubscribeTypeEnum.有异常记录推送;
        Set<String> noPassRecordUserIds = userIdFilter(userIds, noPassMsgTypeEnum.getMsgType());
        String noPassBody = "";
        noPassBody += "巡检时间：" + DateUtil.formatDatrToStr(checkPointBo.getCheckTime(), DateUtil.LONG_PATTERN) + TAB;
        noPassBody += "巡检人员：" + userName + TAB;
        noPassBody += "巡检点名称：" + checkPointBo.getPointName() + TAB;
        noPassBody += "点编号：" + checkPointBo.getPointNo() + TAB;
        noPassBody += "当前状态：异常" + TAB;
        noPassBody += "异常项：" + checkPointBo.getErrorItem() + TAB;
        saveAndSendMsg(checkPointBo.getOrgCode(), noPassRecordUserIds, noPassMsgTypeEnum.getTitle(), noPassBody, noPassMsgTypeEnum.getMsgType(), checkId, null);
        Set<String> noPassRecordEmailAfterFilterUserIds = userIdFilter(noPassRecordUserIds, eamilMsgTypeEnum.getMsgType());
        sendEmail(noPassRecordEmailAfterFilterUserIds, noPassMsgTypeEnum.getTitle(), noPassBody);
    }


    /**
     * 隐患排查-漏检-发送执行人，设备设施责任人
     */
    @Async("asyncTaskExecutor")
    public void pushOverTimeCheckRecordMessage(Long checkId,String time) {
    	String deptName = "";
    	String userName = "";
        CheckPointBo checkPointBo = msgMapper.getPointInfo(checkId);
        if (checkPointBo == null) {
            return;
        }
        List<String> pointClassIdList = iCheckInputDao.findPointClassifyIdByCheckId(checkId);
        Check check = iCheckDao.findById(checkId).get();
        HashMap<String,Object> map = new HashMap<String,Object>();
    	map.put("pointId", check.getPointId());
    	map.put("pointclassifyIds", pointClassIdList);
       
    	
//    	Set<String> userIds = msgMapper.getPointLeaderUserId(map);//风险因素关联的设备责任人
//        if (CollectionUtils.isEmpty(userIds)) {
//            return;
//        }
        
    	 Set<String> userIds=new HashSet<>();
         //查询当前点的责任人
           String   id=  "".equals(map.get("pointId")+"")?null:(map.get("pointId")+"");
          Map<String, String> mapi=  msgMapper.getuserid(id);
          if(mapi!=null&&!mapi.isEmpty()){
       	String  ids=   mapi.get("charge_person_id");
       	String idg[]=ids.split(",");
       
       	
       	for (int i = 0; i < idg.length; i++) {
       		userIds.add(idg[i]);
			}
       	
       	
          }else{
       	   return ;
          }
        
          
        
        MsgSubscribeTypeEnum eamilMsgTypeEnum = MsgSubscribeTypeEnum.推送检查记录消息;
        MsgSubscribeTypeEnum msgTypeEnum = MsgSubscribeTypeEnum.有漏检推送;
        Set<String> filterUserIds = userIdFilter(userIds, msgTypeEnum.getMsgType());
        
         String ids1[]= check.getUserId().split(",");
        if(ids1!=null&&ids1.length>0){
         for (int i = 0; i < ids1.length; i++) {
        	 filterUserIds.add(ids1[i]);//执行人  
		}
        }
         
            
        filterUserIds.remove("");
        filterUserIds.remove(null);
        if(StringUtil.isNotEmpty(checkPointBo.getExecuteDeptId()) ){
        	//获取缓存
            CacheMap cacheMap= CacheFactory.newChacheMap();
            Toke  toke=  cacheMap.getValue(TOKE);
            if(toke==null){
            	toke= remoteSecurityService.come();
            	Long times=  (long) (20*24*60*60);
            	cacheMap.setex(TOKE, toke, times);
            }
           
        	List<LinkedHashMap> departmentBos = remoteSecurityService.listDepartmentByDeptIds(toke.getToke(),toke.getProduct(),toke.getAppKey(),checkPointBo.getExecuteDeptId());
        	//Map<Long, DepartmentModel> departmentBoMap = Maps.uniqueIndex(departmentBos, DepartmentModel::getSequenceNbr);
        	
        	Map<String, DepartmentModel>   deptMap = new HashMap<>();

            for (int i = 0; i < departmentBos.size(); i++) {
            	DepartmentModel departmentBo4 =new DepartmentModel();
            	departmentBo4.setDepartmentName(departmentBos.get(i).get("departmentName").toString());
            	deptMap.put(departmentBos.get(i).get("sequenceNbr").toString(),departmentBo4 );
			}
        	
        	
        	
        	DepartmentModel dept = deptMap.get(checkPointBo.getExecuteDeptId()+"");
        	if(dept != null) {
        		deptName = dept.getDepartmentName();
        	}
        }
        if(StringUtil.isNotEmpty(checkPointBo.getExecuteUserId()) ){
        	//获取缓存
            CacheMap cacheMap= CacheFactory.newChacheMap();
            Toke  toke=  cacheMap.getValue(TOKE);
            if(toke==null){
            	toke= remoteSecurityService.come();
            	Long times=  (long) (20*24*60*60);
            	cacheMap.setex(TOKE, toke, times);
            }
           
        /*	List<AgencyUserModel> userModels = remoteSecurityService.listUserByUserIds(toke.getToke(),toke.getProduct(),toke.getAppKey(),checkPointBo.getExecuteUserId());
        	Map<String, AgencyUserModel> userMap = Maps.uniqueIndex(userModels, AgencyUserModel::getUserId);
        	AgencyUserModel user =  userMap.get(checkPointBo.getExecuteUserId());
        	if (user != null) {
        		userName = user.getRealName();
        	}*/
	List<AgencyUserModel> userModels = remoteSecurityService.listUserByUserIds(toke.getToke(),toke.getProduct(),toke.getAppKey(),checkPointBo.getExecuteUserId());
        	//Map<String, UserModel> userMap = Maps.uniqueIndex(userModels, UserModel::getUserId);	
        	if(userModels!=null&&userModels.size()>0){
        		for (int i = 0; i < userModels.size(); i++) {
        			if(i==userModels.size()-1){
        				userName = userName+userModels.get(i).getRealName();	
        			}else{
        				userName = userName+userModels.get(i).getRealName()+",";	
        			}
            		
    			}
        	}
        }
        String body = "";
        body += "巡检点名称：" + checkPointBo.getPointName() + TAB;
        body += "点编号：" + checkPointBo.getPointNo() + TAB;
        body += "计划名称：" + checkPointBo.getPlanName() + TAB;
        body += "执行部门：" + deptName + TAB; 
        body += "执行人：" + userName + TAB; 
        body += "应执行时间段：" + time + TAB; 
        body += "当前状态：漏检" + TAB;
        
     
        saveAndSendMsg(checkPointBo.getOrgCode(), 
        		filterUserIds, msgTypeEnum.getTitle(), body, msgTypeEnum.getMsgType(), checkId, null,checkPointBo.getXid(),checkPointBo.getPid());
        Set<String> noPassRecordEmailAfterFilterUserIds = userIdFilter(filterUserIds, eamilMsgTypeEnum.getMsgType());
        sendEmail(noPassRecordEmailAfterFilterUserIds, msgTypeEnum.getTitle(), body);
    
        }
    /**
     * 检查计划
     */
    @Async("asyncTaskExecutor")
    public void pushPlanTaskMessage(PlanTask planTask, String jobType) {
        MsgSubscribeTypeEnum msgTypeEnum = null;
        TaskMsgBo taskMsgBo = null;
      // jobType= jobType.substring(0,jobType.lastIndexOf("-"));
        
        if (jobType.contains(XJConstant.PLAN_TASK_WARN_MSG_PUSH)) {
            msgTypeEnum = MsgSubscribeTypeEnum.计划开始前推送;
            taskMsgBo = msgMapper.getPlanTaskWarnMsgBos(planTask.getId());
        } else if (jobType.contains(XJConstant.PLAN_TASK_BEGIN_MSG_PUSH)) {
            if (PlanTaskFinishStatusEnum.UNDERWAY.getValue() == planTask.getFinishStatus()) {
                int count = planTaskDetailDao.countByIsFinishAndTaskNo(PlanTaskDetailIsFinishEnum.FINISHED.getValue(),planTask.getId());
                if (count == 0) {
                    msgTypeEnum = MsgSubscribeTypeEnum.计划开始后推送;
                    taskMsgBo = msgMapper.getPlanTaskBeginMsgBos(planTask.getId());
                }
            }
        } else if (jobType.contains(XJConstant.PLAN_TASK_END_MSG_PUSH)) {
            msgTypeEnum = MsgSubscribeTypeEnum.计划漏检推送;
            taskMsgBo = msgMapper.getPlanTaskEndMsgBos(planTask.getId());
        }
        if (msgTypeEnum == null || taskMsgBo == null) {
            return;
        }
        Set<String> userIds = Sets.newHashSet(taskMsgBo.getUserId().split(","));
        Set<String> filterUserIds = userIdFilter(userIds, msgTypeEnum.getMsgType());
        String body = taskMsgBo.getPushMsg();
        saveAndSendMsg(planTask.getOrgCode(), filterUserIds, msgTypeEnum.getTitle(), body, msgTypeEnum.getMsgType(), planTask.getId(), null);
        MsgSubscribeTypeEnum eamilMsgTypeEnum = MsgSubscribeTypeEnum.推送检查计划消息;
        Set<String> noPassRecordEmailAfterFilterUserIds = userIdFilter(filterUserIds, eamilMsgTypeEnum.getMsgType());
        sendEmail(noPassRecordEmailAfterFilterUserIds, msgTypeEnum.getTitle(), body);
    }

    
    
    //巡检计划状态变化推送
    public void pushChartResulplantask() {		
		//发送数据 0:刷新
		WebsocketParam param = new WebsocketParam("plantask",  "planTaskRefresh");
		client.sendMessage(param);
			
		
	}
    /**
     * 巡检计划涉及支付业务推送
     */
    public void pushChartResulPaytask() {
        //发送数据 payRefresh:支付业务刷新
        WebsocketParam param = new WebsocketParam("plantask", "payRefresh");
        client.sendMessage(param);
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
	public void pushChartResult() {
		HashMap<String, Object> res = msgMapper.queryRouteChartResult();
		if(res != null) {
			String deptId = (String) res.get("deptId");
			if(deptId != null) {
				//获取缓存
		        CacheMap cacheMap= CacheFactory.newChacheMap();
		        Toke  toke=  cacheMap.getValue(TOKE);
		        if(toke==null){
		        	toke= remoteSecurityService.come();
		        	Long times=  (long) (20*24*60*60);
		        	cacheMap.setex(TOKE, toke, times);
		        }
		       
				DepartmentModel depMo = remoteSecurityService.getDepartmentByDeptId(toke.getToke(),toke.getProduct(),toke.getAppKey(),deptId);
				if(depMo!= null) {
					res.put("deptCode", depMo.getDeptOrgCode());
					res.put("orgCode", depMo.getOrgCode());
					res.put("deptName", depMo.getDepartmentName());
				}
				
				//发送数据
				WebsocketParam param = new WebsocketParam("routeChartData", JSON.toJSONString(res));
				client.sendMessage(param);
			}
		}
	}
}
