package com.yeejoin.amos.patrol.service.jpush;

import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jpush.api.JPushClient;
import cn.jpush.api.push.model.Platform;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import cn.jpush.api.push.model.notification.AndroidNotification;
import cn.jpush.api.push.model.notification.Notification;

import com.fasterxml.jackson.databind.annotation.JsonAppend.Attr;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yeejoin.amos.patrol.common.entity.CommonResponse;
import com.yeejoin.amos.patrol.common.enums.JPushTypeEnum;
import com.yeejoin.amos.patrol.service.business.param.PushMsgParam;
import com.yeejoin.amos.patrol.service.constants.XJConstant;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import cn.jpush.api.push.model.Options;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import cn.jpush.api.push.model.PushPayload.Builder;

@Service
@Component
public class AppMessagePushService {


    protected static final Logger log = LoggerFactory
            .getLogger(AppMessagePushService.class);

    
    @Autowired
    private  com.yeejoin.amos.patrol.service.remote.feign.PushFeign PushFeign;
    
    
//	private static String APP_KEY;
//	    
//    private static String MASTER_SECRET;
//  
//    @Value("${params.jpush.appKey}")
//    public void setAppKey(String appKey) {
//        this.APP_KEY = appKey;
//    }
//    @Value("${params.jpush.masterSecret}")
//    public void setMasterSecret(String masterSecret) {
//        this.MASTER_SECRET = masterSecret;
//    }

    @Value("${params.isPush}")
    private String isPush;

    
    
    
    protected static final String APP_KEY = "fbd69be942f081fcaacd67ef";
    protected static final String MASTER_SECRET = "2f44a2eef0f96f5867a7a7cb";
    //

    private static JPushClient jpushClient = new JPushClient(MASTER_SECRET,
            APP_KEY);

    
    
//	private static JPushClient jpushClient = null;
//
//	public static JPushClient getJPushClient(String APP_KEY, String MASTER_SECRET) {
//		if (jpushClient == null) {
//			return new JPushClient(MASTER_SECRET,
//					APP_KEY);
//		}
//		return jpushClient;
//	}

    public static String buildJpushUserKey(String userId) {
        return XJConstant.JPUSH_USER_KEY + "_" + userId;
    }

    public void sendMessage(List<PushMsgParam> responses) {
    	PushFeign.sendMessage(responses);
//        try {
//            if (responses != null && "true".equals(isPush)) {
//                for (PushMsgParam response : responses) {
//                    PushPayload payload = buildPushPayload(response);
//                    jpushClient.sendPush(payload);
//                }
//            }
//        } catch (Exception e) {
//            log.error(e.getMessage(), e);
//            e.printStackTrace();
//        }
    }

    public PushPayload buildPushPayload(PushMsgParam response) {
    	CommonResponse  commonResponse = PushFeign.buildPushPayload(response);
    	return (PushPayload)commonResponse.getDataList();
//        if (JPushTypeEnum.ALL.getCode().equals(response.getType())) {
//            return PushPayload.newBuilder()
//                    .setPlatform(Platform.android())
//                    .setAudience(Audience.all())
//                    .setNotification(Notification.android(response.getContent(), response.getSubject(), response.getExtras()))
//                    .build();
//        } else if (JPushTypeEnum.TAG.getCode().equals(response.getType())) {
//        	
//        	List<String> recivers = response.getRecivers();
//            List<String> users = Lists.newArrayList();
//            recivers.forEach(e -> users.add(buildJpushUserKey(e)));
//            
//            return PushPayload.newBuilder().setPlatform(Platform.android())
//                    .setAudience(Audience.tag(users))
//                    .setNotification(Notification.android(response.getContent(), response.getSubject(), response.getExtras()))
//                    .build();
//        } else {
//        	
//        	List<String> recivers = response.getRecivers();
//            List<String> users = Lists.newArrayList();
//            recivers.forEach(e -> users.add(buildJpushUserKey(e)));
//            return PushPayload.newBuilder().setPlatform(Platform.android())
//                    .setAudience(Audience.alias(users)).
//                            setNotification(Notification.android(response.getContent(), response.getSubject(), response.getExtras()))
//                    .build();
//        }

    }

    public boolean pushNoticeManyMethod(PushMsgParam response) {
        CommonResponse  commonResponse = PushFeign.pushNoticeMany(response);
        if (commonResponse.getResult().equals("SUCCESS")){
            return true;
        } else {
            return false;
        }
    }

    public void sendMessage(PushMsgParam response) {
    	CommonResponse  commonResponse = PushFeign.sendMessageone(response);
    	
//        try {
//            if (null != response && "true".equals(isPush)) {
//                PushPayload payload = PushPayload.newBuilder().setPlatform(Platform.android())
//                        .setAudience(Audience.all())
//                        .setNotification(Notification.android(response.getContent(), response.getSubject(), response.getExtras()))
//                        .build();
//                jpushClient.sendPush(payload);
//            }
//        } catch (Exception e) {
//            log.error(e.getMessage(), e);
//            e.printStackTrace();
//
//        }
    }
    
    
    
    
           /**
            * ���͵�ָ������
            * 
            * */
		    
		    public   void pushNoticeMany( PushMsgParam response){
		    	CommonResponse  commonResponse = PushFeign.pushNoticeMany(response);
		    
//		    	 PushPayload payload = (PushPayload)commonResponse.getDataList();
//                 try {
//					jpushClient.sendPush(payload);
//				} catch (APIConnectionException e) {
//					// TODO Auto-generated catch block
//					e.printStackTrace();
//				} catch (APIRequestException e) {
//					// TODO Auto-generated catch block
//					e.printStackTrace();
//				}
		      
		     }
}
