package com.yeejoin.amos.patrol.service.quartz;

//import com.yeejoin.amos.op.core.util.DateUtil;
import com.yeejoin.amos.patrol.common.entity.Check;
import com.yeejoin.amos.patrol.common.entity.CheckInput;
import com.yeejoin.amos.patrol.common.entity.DateUtil;
import com.yeejoin.amos.patrol.common.entity.Msg;
import com.yeejoin.amos.patrol.common.entity.PlanTask;
import com.yeejoin.amos.patrol.common.entity.PlanTaskDetail;
import com.yeejoin.amos.patrol.common.entity.Task;
import com.yeejoin.amos.patrol.common.entity.TaskFeedback;
import com.yeejoin.amos.patrol.common.enums.CheckStatusEnum;
import com.yeejoin.amos.patrol.common.enums.MsgSubscribeTypeEnum;
import com.yeejoin.amos.patrol.common.enums.PlanTaskDetailIsFinishEnum;
import com.yeejoin.amos.patrol.common.enums.PlanTaskDetailStatusEnum;
import com.yeejoin.amos.patrol.common.enums.PlanTaskFinishStatusEnum;
import com.yeejoin.amos.patrol.common.enums.TaskStatusEnum;
import com.yeejoin.amos.patrol.service.business.bo.patrol.PlanTaskPointInputItemBo;
import com.yeejoin.amos.patrol.service.business.dao.mapper.MsgMapper;
import com.yeejoin.amos.patrol.service.business.dao.mapper.PlanTaskMapper;
import com.yeejoin.amos.patrol.service.business.dao.repository.ICheckDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.ICheckInputDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IMsgDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IPlanTaskDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.IPlanTaskDetailDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.ITaskDao;
import com.yeejoin.amos.patrol.service.business.dao.repository.ITaskFeedbackDao;
import com.yeejoin.amos.patrol.service.business.param.MsgConfigParam;
import com.yeejoin.amos.patrol.service.business.service.intfc.IMessageService;
import com.yeejoin.amos.patrol.service.business.util.CacheFactory;
import com.yeejoin.amos.patrol.service.business.util.CacheMap;
import com.yeejoin.amos.patrol.service.business.util.Toke;
import com.yeejoin.amos.patrol.service.constants.XJConstant;
import com.yeejoin.amos.patrol.service.core.async.AsyncTask;
import com.yeejoin.amos.patrol.service.remote.RemoteSecurityService;
import com.yeejoin.amos.patrol.service.remote.RemoteWebSocketServer;
import org.quartz.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Service("jobService")
public class JobService implements IJobService {

    private final Logger log = LoggerFactory.getLogger(JobService.class);

    @Autowired
    private ITaskDao iTaskDao;

    @Autowired
    private IPlanTaskDao iPlanTaskDao;

    @Autowired
    private IPlanTaskDetailDao iPlanTaskDetailDao;

    @Autowired
    private IMessageService messageService;

    @Autowired
    private PlanTaskMapper planTaskMapper;

    @Autowired
    private MsgMapper msgMapper;

    @Autowired
    private ICheckDao iCheckDao;

    @Autowired
    private ICheckInputDao iCheckInputDao;

    @Autowired
    private AsyncTask asyncTask;

    @Autowired
    private IMsgDao iMsgDao;

    @Autowired
    private ITaskFeedbackDao taskFeedbackDao;
    @Autowired
    private RemoteSecurityService remoteSecurityService;
    private static final String TOKE = "TOKE";

//    @Autowired
//    private RemoteJiaodaService remoteJiaodaService;

    @Autowired
    private RemoteWebSocketServer remoteWebSocketServer;

    @Override
    public void initScheduler() {
        log.info("====================>初始化任务开始");
        initTaskJob();
        initPlanTaskJob();
        initMsgJob();
        log.info("====================>初始化任务完成");
    }

    @Override
    public void addJob(String name, String jobType, long id, Date time) {
        String jobName = name + "-" + jobType + "-" + id;
        if (time != null && time.getTime() > new Date().getTime()) {
            SimpleDateFormat formatter = new SimpleDateFormat("ss mm HH dd MM ? yyyy");
            String cronDate = formatter.format(time);
            log.debug("addJob==jobName==" + jobName);
            QuartzManager.addJob(jobName, jobType, id, getJobInstance(name).getClass(), cronDate);
        }
    }

    /**
     * 初始化任务job
     */
    private void initTaskJob() {
        List<Task> taskList = iTaskDao.findAllByStatus(TaskStatusEnum.UNDERWAY.getValue());
        List<Task> updateTask = new ArrayList<Task>();
        taskList.forEach(task -> {
            Date finishTime = task.getFinishTime();
            if (finishTime != null) {
                if (finishTime.getTime() > new Date().getTime()) {
                    taskAddJob(task);
                } else {
                    task.setStatus(TaskStatusEnum.OVERTIME.getValue());
                    updateTask.add(task);
                }
            }
        });
        iTaskDao.saveAll(updateTask);
    }

    /**
     * 初始化计划执行job
     */
    private void initPlanTaskJob() {
        List<Integer> statusList = new ArrayList<Integer>();
        statusList.add(PlanTaskFinishStatusEnum.NOTSTARTED.getValue());
        statusList.add(PlanTaskFinishStatusEnum.UNDERWAY.getValue());
        List<PlanTask> planTaskList = iPlanTaskDao.findAllByFinishStatusIn(statusList);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        planTaskList.forEach(planTask -> {
            try {
                Date beginTime = sdf.parse(planTask.getBeginTime());
                Date endTime = sdf.parse(planTask.getEndTime());
                long timestamp = new Date().getTime();
                if (PlanTaskFinishStatusEnum.NOTSTARTED.getValue() == planTask.getFinishStatus()) {
                    if (beginTime.getTime() > timestamp) {
                        planTaskAddJob(planTask);
                    } else if (beginTime.getTime() < timestamp && endTime.getTime() > timestamp) {
                        planTask.setFinishStatus(PlanTaskFinishStatusEnum.UNDERWAY.getValue());
                        iPlanTaskDao.save(planTask);                       
                       //增加推送进行中
                       asyncTask.pushChartResulplantask();
                       
                        planTaskAddJob(planTask);
                    } else if (endTime.getTime() < timestamp) {
                        updatePlanTaskStatus(planTask, PlanTaskFinishStatusEnum.OVERTIME.getValue());
                    }
                } else {
                    if (endTime.getTime() < timestamp) {
                        updatePlanTaskStatus(planTask, PlanTaskFinishStatusEnum.OVERTIME.getValue());
                    } else {
                        planTaskAddJob(planTask);
                    }
                }
            } catch (ParseException e) {
                // TODO Auto-generated catch block
                log.debug(e.getMessage());
                e.printStackTrace();
            }
        });

    }

    private void initMsgJob() {
        List<Msg> msgList = iMsgDao.findAllByIsImmediatelyTrueAndStatus(0);
        if (!msgList.isEmpty()) {
            msgList.forEach(msg -> {
                addJob("msg", XJConstant.MESSAGE_PUSH, msg.getId(), msg.getFixedTime());
            });
        }
    }

    private void updatePlanTaskStatus(PlanTask planTask, int status) {
        planTask.setFinishStatus(status);
        iPlanTaskDao.saveAndFlush(planTask);
        
        //增建已超时，已完成，推送    
        asyncTask.pushChartResulplantask();
        
        List<PlanTaskDetail> planTaskDetails = iPlanTaskDetailDao.findAllByTaskNoAndStatus(planTask.getId(), PlanTaskDetailStatusEnum.NOTSTARTED.getValue());
        if (!planTaskDetails.isEmpty()) {
            planTaskDetails.stream()
                    .forEach(action -> {
                        action.setIsFinish(PlanTaskDetailIsFinishEnum.OVERTIME.getValue());
                        action.setStatus(PlanTaskDetailStatusEnum.OMISSION.getValue());
                        iPlanTaskDetailDao.saveAndFlush(action);
                    });
        }
        if (PlanTaskFinishStatusEnum.OVERTIME.getValue() == status) {
            createOmissionCheckRecord(planTask);
        }
    }

    /**
     * 创建漏检检查记录
     *
     * @param planTask
     */
    private void createOmissionCheckRecord(PlanTask planTask) {
        List<PlanTaskPointInputItemBo> planTaskPointInputItems = planTaskMapper
                .getPlanTaskPointInputItemByPlanTaskId(planTask.getId(), PlanTaskDetailStatusEnum.OMISSION.getValue());
        Map<Long, Check> checkMap = new HashMap<>();
        //List<CheckInput> checkInputList = new ArrayList<CheckInput>();
        Set<Long> checkIds = new HashSet<Long>();
        //执行时间段
       
        Map<Long, String> map=new HashMap<>();
        Set<Long> checkIdslist = new HashSet<Long>();
        
        planTaskPointInputItems.forEach(arg -> {
            Check check = new Check();
            if (checkMap.get(arg.getPointId()) == null) {
                check.setOrgCode(arg.getOrgCode());
                check.setUserId(arg.getUserId());
                check.setPointId(arg.getPointId());
                check.setUploadTime(arg.getEndTime());
                check.setPlanId(arg.getPlanId());
                check.setPlanTaskId(arg.getPlanTaskId());
                check.setPlanTaskDetailId(arg.getPlanTaskDetailId());
                check.setRouteId(arg.getRouteId());
                check.setCheckTime(arg.getEndTime());
                check.setIsOk(CheckStatusEnum.OMISSION.getCode());
                //新增加部门id
                check.setDepId(arg.getDepId());
                
                check = iCheckDao.saveAndFlush(check);
                checkMap.put(arg.getPointId(), check);
                checkIds.add(check.getId());
                
                
                map.put(check.getId(), arg.getBegintimes()+":"+arg.getEndtimes());
            } else {
                check = checkMap.get(arg.getPointId());
            }
            if (arg.getInputItemId() != null) {
                CheckInput checkInput = new CheckInput();
                checkInput.setCheckId(check.getId());
                checkInput.setInputId(arg.getInputItemId());
                checkInput.setIsOk(CheckStatusEnum.OMISSION.getCode());
                checkInput.setRoutePointItemId(arg.getRoutePointItemId());
                checkInput.setOrderNo(arg.getOrderNo());
                checkInput.setOrgCode(arg.getOrgCode());
                checkInput.setInputName(arg.getInputName());
                checkInput.setPointClassifyId(arg.getClassifyId());
                checkInput.setPointClassifyName(arg.getClassifyName());
                iCheckInputDao.saveAndFlush(checkInput);
            }
        });
        
        checkIdslist=  map.keySet();
        // 向3d推送数据,发送消息推送
        checkIdslist.forEach(checkId -> {
          try {
              asyncTask.pushCheckInfoTo3D(checkId);
              asyncTask.pushOverTimeCheckRecordMessage(checkId,map.get(checkId));
          } catch (InterruptedException e) {
              log.error(e.getMessage(), e);
              e.printStackTrace();
          }
      });
              
              
              
        // 向3d推送数据,发送消息推送
//        checkIds.forEach(checkId -> {
//            try {
//                asyncTask.pushCheckInfoTo3D(checkId);
//                asyncTask.pushOverTimeCheckRecordMessage(checkId,time);
//            } catch (InterruptedException e) {
//                log.error(e.getMessage(), e);
//                e.printStackTrace();
//            }
//        });
        //向web推送刷新指令
        remoteWebSocketServer.wsDataRefresh("check");
    }

    private void removeJob(String jobName) {
        log.debug("removeJob==jobName==" + jobName);
        QuartzManager.removeJob(jobName);
    }

    private Job getJobInstance(String type) {
        switch (type) {
            case "planTask":
                return new PlanTaskJobService();
            case "task":
                return new TaskJobService();
            case "msg":
                return new MsgJobService();
            default:
                return null;
        }
    }

    @Override
    public void taskAddJob(Task task) {
        // TODO Auto-generated method stub
        long taskId = task.getId();
        if (XJConstant.TASK_WARN.equals(task.getIsWarn())) { // 设置为接受报警执行代码
            Date alarmDate = task.getWarnTime();
            addJob("task", XJConstant.MESSAGE_PUSH, taskId, alarmDate);
        }
        addJob("task", XJConstant.STATUS_MONITOR_END, taskId, task.getFinishTime());

    }

    @Override
    @Transactional
    public void taskJobPerform(long taskId, String jobType, String jobName) {
        // TODO Auto-generated method stub
        if (iTaskDao.existsById(taskId)) {
            Task task = iTaskDao.findById(taskId).get();
            if (XJConstant.STATUS_MONITOR_END.equals(jobType)) {
                if (TaskStatusEnum.UNDERWAY.getValue() == task.getStatus()) {
                    task.setStatus(TaskStatusEnum.OVERTIME.getValue());
                    iTaskDao.saveAndFlush(task);
                    TaskFeedback taskFeedback = new TaskFeedback();
                    taskFeedback.setUserId(task.getExecutorId());
                    taskFeedback.setMessage("该任务在规定时间内未完成，请核实信息！任务名称： " + task.getTitle() + " 要求完成时间：  "
                            + DateUtil.getDateFormat(task.getFinishTime(), "yyyy-MM-dd HH:mm:ss") + " 发起人："
                            + task.getPublisherName() + " 执行人：" + task.getExecutor());
                    taskFeedback.setCreateDate(new Date());
                    taskFeedback.setUserName(task.getExecutor());
                    taskFeedback.setFeedbackTime(new Date());
                    taskFeedback.setOrgCode(task.getOrgCode());
                    taskFeedback.setTaskId(task.getId());
                    taskFeedback.setMessageType(TaskStatusEnum.OVERTIME.getName());
                    taskFeedback = taskFeedbackDao.save(taskFeedback);
                    try {
                        asyncTask.pushTaskDetailInfoTo3D(taskId); // 超时任务向3D推送
                    } catch (InterruptedException e) {
                        // TODO Auto-generated catch block
                        log.error(e.getMessage(), e);
                        e.printStackTrace();
                    }
                }
            } else {
            	 //获取缓存
                CacheMap cacheMap= CacheFactory.newChacheMap();
                Toke  toke=  cacheMap.getValue(TOKE);
                if(toke==null){
                	toke= remoteSecurityService.come();
                	Long times=  (long) (20*24*60*60);
                	cacheMap.setex(TOKE, toke, times);
                }
                messageService.pushTaskMessage(toke.getToke(),toke.getProduct(),toke.getAppKey(),task);
            }
        }
        removeJob(jobName);
    }

    @Override
    public void planTaskAddJob(PlanTask planTask) {
        // TODO Auto-generated method stub
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date endTime = sdf.parse(planTask.getEndTime());
            Date beginTime = sdf.parse(planTask.getBeginTime());
            if (PlanTaskFinishStatusEnum.OVERTIME.getValue() != planTask.getFinishStatus()) {

                // 添加状态监控定时

                int status = planTask.getFinishStatus();
                if (PlanTaskFinishStatusEnum.NOTSTARTED.getValue() == status) {
                    addJob("planTask", XJConstant.STATUS_MONITOR_START, planTask.getId(), beginTime);// 添加监控任务开始时间定时任务
                }
                if (PlanTaskFinishStatusEnum.NOTSTARTED.getValue() == status
                        || PlanTaskFinishStatusEnum.UNDERWAY.getValue() == status) {
                    addJob("planTask", XJConstant.STATUS_MONITOR_END, planTask.getId(), endTime);// 添加监控任务开始结束定时任务
                }
                // 查询需要推送消息提醒
               	List<MsgConfigParam> configParam = msgMapper.getPlanTaskMsgConfigByUserIdAndStatus(planTask.getUserId().split(","),
                        "True");
                if (!configParam.isEmpty()) {
                    configParam.forEach(config -> {
                        String jobType = "";
                        Date time = new Date();
                        int minute = Integer.valueOf(config.getValue());
                        long tempTime = minute * 60 * 1000;
                        if (MsgSubscribeTypeEnum.计划开始后推送.getMsgType().equals(config.getMsgType())) {
                            time = new Date(beginTime.getTime() + tempTime);
                            jobType = XJConstant.PLAN_TASK_BEGIN_MSG_PUSH + "-" + config.getUserId();
                        } else if (MsgSubscribeTypeEnum.计划开始前推送.getMsgType().equals(config.getMsgType())) {
                            time = new Date(beginTime.getTime() - tempTime);
                            jobType = XJConstant.PLAN_TASK_WARN_MSG_PUSH + "-" + config.getUserId();
                        } else if (MsgSubscribeTypeEnum.计划漏检推送.getMsgType().equals(config.getMsgType())) {
                            time = new Date(endTime.getTime() + tempTime);
                            jobType = XJConstant.PLAN_TASK_END_MSG_PUSH + "-" + config.getUserId();
                        }
                        addJob("planTask", jobType, planTask.getId(), time);
                    });
                }

            } else {
                updatePlanTaskStatus(planTask, PlanTaskFinishStatusEnum.OVERTIME.getValue());
            }
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            e.printStackTrace();
        }
    }

    @Override
    @Transactional
    public void planTaskJobPerform(long planTaskId, String jobType, String jobName) {
        if (iPlanTaskDao.existsById(planTaskId)) {
            PlanTask planTask = iPlanTaskDao.findById(planTaskId).get();
            if (XJConstant.STATUS_MONITOR_START.equals(jobType)) {
                if (PlanTaskFinishStatusEnum.NOTSTARTED.getValue() == planTask.getFinishStatus()) {
                    planTask.setFinishStatus(PlanTaskFinishStatusEnum.UNDERWAY.getValue());
                    iPlanTaskDao.saveAndFlush(planTask);
                    //增加推送进行中
                    asyncTask.pushChartResulplantask();
                }
            } else if (XJConstant.STATUS_MONITOR_END.equals(jobType)) {
                if (PlanTaskFinishStatusEnum.UNDERWAY.getValue() == planTask.getFinishStatus()) {
                    updatePlanTaskStatus(planTask, PlanTaskFinishStatusEnum.OVERTIME.getValue());
                    //  Plan plan = iPlanDao.findOne(planTask.getPlanId());
//                    if (plan != null) {
//                        remoteJiaodaService.updatePlanState(plan.getOriginalId(), "已过期");
//                    }
                }
            } else {
                asyncTask.pushPlanTaskMessage(planTask, jobType);
            }
        }
        removeJob(jobName);
    }

    @Override
    public void msgAddJob(Msg msg) {
        addJob("msg", XJConstant.MESSAGE_PUSH, msg.getId(), msg.getFixedTime());
    }

    @Override
    public void msgJobPerform(long msgId, String jobType, String jobName) {
        if (iMsgDao.existsById(msgId)) {
            Msg msg = iMsgDao.findById(msgId).get();
            messageService.pushMsg(msg);
        }
        removeJob(jobName);
    }

}
