package com.yeejoin.amos.patrol.service.remote;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.yeejoin.amos.patrol.common.enums.JiaodaUriEnum;
import com.yeejoin.amos.patrol.service.business.util.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.Map;

@Service("remoteJiaodaService")
public class RemoteJiaodaService {

    private final Logger logger = LoggerFactory.getLogger(RemoteJiaodaService.class);

    //@Value("${params.jiaoda.address}")
    private String address;

    private String buildUrl(String address, JiaodaUriEnum jiaodaUriEnum, Map<String, String> map) {
        String uri = jiaodaUriEnum.getUri();
        String params = jiaodaUriEnum.getParams();
        if (!StringUtils.isEmpty(params) && map != null) {
            String[] paramsArr = params.split(",");
            for (String param : paramsArr) {
                uri = uri.replace("{" + param + "}", map.get(param));
            }
        }
        return address + uri;
    }

    public JSONObject updatePlanState(String planOriginalId, String state) {
        Map<String, String> map = Maps.newHashMap();
        map.put("planId", planOriginalId);
        map.put("state", state);
        String url = buildUrl(address, JiaodaUriEnum.修改检查计划状态, map);
        String resultStr = HttpUtil.sendHttpPost(url);
        logger.info("\r\n请求路径=======================>" + url + "\r\n执行任务返回参数=======================>" + resultStr);
        return JSONObject.parseObject(resultStr);
    }

}
