package com.yeejoin.amos.patrol.service.remote;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.yeejoin.amos.patrol.common.core.request.CheckResultPushSpcRequest;
import com.yeejoin.amos.patrol.common.core.request.LatentDangerResultPushSpcRequest;
import com.yeejoin.amos.patrol.common.entity.CommonResponse;
import com.yeejoin.amos.patrol.common.enums.RiskFactorWorkFlowActionTypeEnum;
import com.yeejoin.amos.patrol.common.enums.WorkFlowRiskFactorUriEnum;
import com.yeejoin.amos.patrol.service.business.util.HttpUtil;
import com.yeejoin.amos.patrol.service.constants.XJConstant;
import com.yeejoin.amos.patrol.service.remote.feign.AmosBankFeign;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.Map;

@Service("remoteSpcService")
public class RemoteSpcService {

   // @Value("${params.spc.address}")
    private String address;
    @Autowired
    private  AmosBankFeign amosBankFeign;
    private static final String success = "SUCCESS";

    private String buildUrl(String address, WorkFlowRiskFactorUriEnum workFlowRiskFactorUriEnum, Map<String, String> map) {
        String uri = workFlowRiskFactorUriEnum.getUri();
        String params = workFlowRiskFactorUriEnum.getParams();
        if (!StringUtils.isEmpty(params) && map != null) {
            String[] paramsArr = params.split(",");
            for (String param : paramsArr) {
                uri = uri.replace("{" + param + "}", map.get(param));
            }
        }
        return address + uri;
    }

    private JSONObject handleResult(String resultStr) {
        if (resultStr == null) {
            return null;
        }
        JSONObject json = JSON.parseObject(resultStr);
        if (success.equals(json.getString("result"))) {
            return json;
        }
        return null;
    }

    public JSONObject wakeUpOrRestartRiskFactorFlow(String instanceId, WorkFlowRiskFactorUriEnum factorUriEnum, String token, RiskFactorWorkFlowActionTypeEnum actionType) {
        String url = buildUrl(address, factorUriEnum, null);
        JSONObject body = new JSONObject();
        body.put("instanceId", instanceId);
        body.put("actionType", actionType.getActionType());
        Map<String, String> headerMap = Maps.newHashMap();
        headerMap.put(XJConstant.TOKEN_KEY, token);
        String resultStr = HttpUtil.sendHttpPostJsonWithHeader(url, body.toJSONString(), headerMap);
        return handleResult(resultStr);
    }

    public JSONObject pushSpcCheckResult(CheckResultPushSpcRequest checkResultPushSpcRequest) {
       /* String url = buildUrl(address, WorkFlowRiskFactorUriEnum.检查结果推送, null);
        
        // 危险管控措施目前清空
        checkResultPushSpcRequest.setRiskFactorMap(null);
        String stringJson = JSONObject.toJSONString(checkResultPushSpcRequest);
                String resultStr = HttpUtil.sendHttpPostJson(url, stringJson);
        return handleResult(resultStr);*/
    	 String stringJson = JSONObject.toJSONString(checkResultPushSpcRequest);
    	 CommonResponse dtes= amosBankFeign.pushSpcCheckResult(stringJson);
    	 String dtesjson = JSONObject.toJSONString(dtes);   	 
    	 return handleResult(dtesjson);
    }

    public JSONObject pushLatentDangerExcuteResult(LatentDangerResultPushSpcRequest latentDangerResultPushSpcRequest) {
       /* String url = buildUrl(address, WorkFlowRiskFactorUriEnum.隐患治理结果推送, null);
        String stringJson = JSONObject.toJSONString(latentDangerResultPushSpcRequest);
        String resultStr = HttpUtil.sendHttpPostJson(url, stringJson);*/
    	
    	 String stringJson = JSONObject.toJSONString(latentDangerResultPushSpcRequest);
    	 CommonResponse dtes= amosBankFeign.wakeUpOrRestartRiskFactorFlow(stringJson);
    	 String dtesjson = JSONObject.toJSONString(dtes);   	 
    	 return handleResult(dtesjson);
    	
        //return handleResult(resultStr);
    }


}
