package com.yeejoin.amos.patrol.service.remote;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.yeejoin.amos.patrol.common.enums.WorkFlowUriEnum;
import com.yeejoin.amos.patrol.service.business.util.HttpUtil;
import com.yeejoin.amos.patrol.service.constants.XJConstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.Map;

@Service("remoteWorkFlowService")
public class RemoteWorkFlowService {

    private final Logger logger = LoggerFactory.getLogger(RemoteWorkFlowService.class);

    //@Value("${params.work.flow.address}")
    private String address;

    private static final String success = "SUCCESS";

    private static final String appKey = "8b193f7cb22c842b5a56e866c2e20dbf";

    private String buildUrl(String address, WorkFlowUriEnum workFlowUriEnum, Map<String, String> map) {
        String uri = workFlowUriEnum.getUri();
        String params = workFlowUriEnum.getParams();
        if (!StringUtils.isEmpty(params) && map != null) {
            String[] paramsArr = params.split(",");
            for (String param : paramsArr) {
                uri = uri.replace("{" + param + "}", map.get(param));
            }
        }
        return address + uri;
    }

    private JSONObject handleResult(String resultStr) {
        if (resultStr == null) {
            return null;
        }
        JSONObject json = JSON.parseObject(resultStr);
        if (success.equals(json.getString("result"))) {
            return json;
        }
        return null;
    }

    public JSONObject start(String businessKey, String token, String companyId, String departmentId, String processDefinitionKey) {
        String url = buildUrl(address, WorkFlowUriEnum.启动流程, null);
        Map<String, String> headerMap = Maps.newHashMap();
        headerMap.put(XJConstant.TOKEN_KEY, token);
        JSONObject body = new JSONObject();
        body.put("businessKey", businessKey);
        body.put("processDefinitionKey", processDefinitionKey);
        JSONArray variables = new JSONArray();
        JSONObject companyJson = new JSONObject();
        companyJson.put("name", "companyId");
        companyJson.put("value", companyId);
        JSONObject departmentJson = new JSONObject();
        departmentJson.put("name", "departmentId");
        departmentJson.put("value", departmentId);
        variables.add(companyJson);
        variables.add(departmentJson);
        body.put("variables", variables);
        String requestBody = body.toJSONString();
        String resultStr = HttpUtil.sendHttpPostJsonWithHeader(url, requestBody, headerMap);
        logger.info("\r\n请求路径=======================>" + url + "\r\n请求参数=======================>" + requestBody + "\r\n返回参数=======================>" + resultStr);
        return handleResult(resultStr);
    }

    public JSONObject startWithAppKey(JSONObject body) {
        Map<String, String> map = Maps.newHashMap();
        map.put("appKey", appKey);
        String url = buildUrl(address, WorkFlowUriEnum.启动免登录流程, map);
        String requestBody = body.toJSONString();
        String resultStr = HttpUtil.sendHttpPostJson(url, requestBody);
        logger.info("\r\n请求路径=======================>" + url + "\r\n请求参数=======================>" + requestBody + "\r\n返回参数=======================>" + resultStr);
        return handleResult(resultStr);
    }

    public JSONObject stop(String processInstanceId, String deleteReason, String token) {
        Map<String, String> map = Maps.newHashMap();
        map.put("deleteReason", deleteReason);
        map.put("processInstanceId", processInstanceId);
        Map<String, String> headerMap = Maps.newHashMap();
        headerMap.put(XJConstant.TOKEN_KEY, token);
        String url = buildUrl(address, WorkFlowUriEnum.终止流程, map);
        String resultStr = HttpUtil.sendHttpDeleteWithHeader(url, headerMap);
        JSONObject json = handleResult(resultStr);
        logger.info("\r\n请求路径=======================>" + url + "\r\n返回参数=======================>" + resultStr);
        return json;
    }

    public JSONObject excute(String taskId, String requestBody, String token) {
        Map<String, String> map = Maps.newHashMap();
        map.put("taskId", taskId);
        Map<String, String> headerMap = Maps.newHashMap();
        headerMap.put(XJConstant.TOKEN_KEY, token);
        String url = buildUrl(address, WorkFlowUriEnum.执行流程, map);
        String resultStr = HttpUtil.sendHttpPostJsonWithHeader(url, requestBody, headerMap);
        JSONObject json = handleResult(resultStr);
        logger.info("\r\n请求路径=======================>" + url + "\r\n请求参数=======================>" + requestBody + "\r\n返回参数=======================>" + resultStr);
        return json;
    }

    public JSONObject currentTask(String instanceId, String token) {
        Map<String, String> map = Maps.newHashMap();
        map.put("processInstanceId", instanceId);
        String url = buildUrl(address, WorkFlowUriEnum.当前节点, map);
        Map<String, String> headerMap = Maps.newHashMap();
        headerMap.put(XJConstant.TOKEN_KEY, token);
        String resultStr = HttpUtil.sendHttpGetWithHeader(url, headerMap);
        JSONObject json = handleResult(resultStr);
        logger.info("\r\n请求路径=======================>" + url + "\r\n返回参数=======================>" + resultStr);
        if (json == null) {
            return null;
        }
        JSONArray reviewContent = json.getJSONObject("dataList").getJSONArray("content");
        if (reviewContent != null && reviewContent.size() > 0) {
            return reviewContent.getJSONObject(0);
        }
        return null;
    }

    public JSONObject currentTask(String instanceId,String taskDefinitionKey, String token) {
        Map<String, String> map = Maps.newHashMap();
        map.put("processInstanceId", instanceId);
        map.put("taskDefinitionKey", taskDefinitionKey);
        String url = buildUrl(address, WorkFlowUriEnum.当前子节点, map);
        Map<String, String> headerMap = Maps.newHashMap();
        headerMap.put(XJConstant.TOKEN_KEY, token);
        String resultStr = HttpUtil.sendHttpGetWithHeader(url, headerMap);
        JSONObject json = handleResult(resultStr);
        logger.info("\r\n请求路径=======================>" + url + "\r\n返回参数=======================>" + resultStr);
        if (json == null) {
            return null;
        }
        JSONArray reviewContent = json.getJSONObject("dataList").getJSONArray("content");
        if (reviewContent != null && reviewContent.size() > 0) {
            return reviewContent.getJSONObject(0);
        }
        return null;
    }

}
