package com.yeejoin.amos.patrol.service.remote.feign;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import com.yeejoin.amos.patrol.common.core.request.CheckResultPushSpcRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.util.MultiValueMap;

import com.yeejoin.amos.patrol.common.entity.CommonResponse;


//银行运控
@FeignClient(name = "${AmosBank.fegin.name}")
public interface AmosBankFeign {


		    
		@RequestMapping(value = "/api/protal/data", method = RequestMethod.GET)
		CommonResponse pushSpcCheckResult( @RequestParam("date") String permissionType);
	
	    
	    @RequestMapping(value = "/api/protal/hiddentrouble", method = RequestMethod.GET)
	    CommonResponse wakeUpOrRestartRiskFactorFlow( @RequestParam("date") String permissionType);
	    
	  
	    @RequestMapping(value = "/rtsp/listVideoByPage", method = RequestMethod.POST ,consumes="application/json")
		CommonResponse getVideos( @RequestBody MultiValueMap<String, Object>  param);
	    
	    @RequestMapping(value = "/rtsp/listVideoByPage/{orgCode}/{parentId}/{current}/{pageSize}", method = RequestMethod.POST)
		CommonResponse getVideos(
				@PathVariable("orgCode") String orgCode,
				@PathVariable("current") Integer current,
				@PathVariable("pageSize") Integer pageSize,
				@PathVariable("parentId") Long parentId);
}
