package com.yeejoin.amos.patrol.service.remote.feign;

import javax.servlet.http.HttpServletRequest;

import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import feign.RequestInterceptor;
import feign.RequestTemplate;

public class FeignBasicAuthRequestInterceptor implements RequestInterceptor {
    public FeignBasicAuthRequestInterceptor() {

    }

    @Override
    public void apply(RequestTemplate template) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return;
        }
        ServletRequestAttributes attributes = (ServletRequestAttributes) requestAttributes;
        if (attributes != null) {
            HttpServletRequest request = attributes.getRequest();
            /* Get token from header */
            String authToken = request.getHeader("X-Access-Token");
            /* If token not found get it from request parameter */
            if (authToken == null) {
                authToken = request.getParameter("token");
            }
            template.header("X-From-Service", "true");
            template.header("X-Access-Token", authToken);
        }
    }
}
