package com.yeejoin.amos.patrol.service.remote.feign;

import com.alibaba.fastjson.JSONObject;
//import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.patrol.common.entity.CommonResponse;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

//@FeignClient(name = "${security.fegin.name}", configuration = FeignConfiguration.class)
public interface IAMOSSecurityServer {

    @GetMapping(value = "/v1/company/tree")
    CommonResponse listCompanyTree();

    @GetMapping(value = "/v1/user/list")
    CommonResponse listUserByMenuCode(@RequestParam("permissionType") String permissionType, @RequestParam("path") String path);

    @GetMapping(value = "/v1/department/{departmentId}")
    CommonResponse getDepartmentByDeptId(@PathVariable("departmentId") String departmentId);

    @GetMapping(value = "/v1/department/list/{departmentIds}")
    CommonResponse listDepartmentByDeptIds(@PathVariable("departmentIds") String departmentIds);

    /**
     * 根据公司编号查询部门集合（数组）
     */
    @GetMapping(value = "/v1/department/tree/{companyId}")
    CommonResponse listDepartmentsByCompanyId(@PathVariable("companyId") String companyId);

    /**
     * 根据公司编号查询用户集合
     */
    @GetMapping(value = "/v1/department/tree/{companyId}")
    CommonResponse listUserByCompanyId(@PathVariable("companyId") String companyId);

    @GetMapping(value = "/v1/user/list/role/{roleIds}")
    CommonResponse listUserByRoleIds(@PathVariable("roleIds") String roleIds);

    @GetMapping(value = "/v1/user/list/batch/{userIds}")
    CommonResponse listUserByUserIds(@PathVariable("userIds") String userIds);

    @GetMapping(value = "/v1/user/{userId}")
    CommonResponse getUserById(@PathVariable("userId") String userId);
   
    @GetMapping(value = "/v1/user/me")
    CommonResponse getUserByToken();
    
    /**
     * 根据公司组织机构代码查询用户集合
     */
    @GetMapping(value = "/v1/company")
    CommonResponse listUserByOrgCode(@RequestParam("orgCode") String orgCode);

    @GetMapping(value = "/v1/user/list/dept/{departmentId}")
    CommonResponse listUserByDepartmentId(@PathVariable("departmentId") String departmentId);

    @GetMapping(value = "/v1/company/subtree/{companyId}")
    CommonResponse getCompanyTreeByCompanyId(@PathVariable("companyId") String companyId);

    @GetMapping(value = "/v1/department/tree/{companyId}")
    CommonResponse getDepartmentTreeByCompanyId(@PathVariable("companyId") String companyId);

    @GetMapping(value = "/v1/permission/tree/curruser")
    CommonResponse listPermissionTree(@RequestParam("menuAgent") String menuAgent);

    @GetMapping(value = "/v1/dictionary/dictValues")
    CommonResponse listDictionaryByDictCode(@RequestParam("dictCode") String dictCode);
    
    @GetMapping(value = "/v1/user/tree/{companyId}")
    CommonResponse getuserTreeByCompanyId(@PathVariable("companyId") String companyId);
    @PostMapping(value = "/v1/system/appLogin")
    CommonResponse loginFromApp(@RequestBody JSONObject appLoginParam);

    @DeleteMapping(value = "/v1/system/loginOut")
    CommonResponse loginOutFromApp();

    @GetMapping(value = "/v1/user/tree/{companyId}")
    CommonResponse listDepartmentUserTree(@PathVariable("companyId") String companyId);

    @PutMapping(value = "/v1/user/{userId}/password")
    CommonResponse editPassword(@PathVariable("userId") String userId,
                                @RequestBody JSONObject model);
}
