package com.yeejoin.amos.patrol.service.remote.feign;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import com.fasterxml.jackson.databind.ObjectMapper;
//import com.yeejoin.amos.op.core.util.Constants;
//import com.yeejoin.amos.op.core.util.JSONUtil;
import com.yeejoin.amos.patrol.common.entity.Constants;
import com.yeejoin.amos.patrol.common.entity.JSONUtil;

/**
 *
 * <pre>
 * 规则模型系统远程调用
 * </pre>
 *
 * @author amos
 * @version $Id: RemoteRuleServer.java, v 0.1 2019年5月7日 下午5:52:21 amos Exp $
 */
@Service("remoteRuleServer")
public class RemoteRuleServer
{
    private final RestTemplate restTemplate;


    //@Value("${params.remoteRuleUrl}")
    private String remoteRuleUrl;

    private ObjectMapper objectMapper = new ObjectMapper();
    public RemoteRuleServer()
    {
        this.restTemplate = new RestTemplate();
    }

    /**
     *
     * <pre>
     * 触发规则
     * </pre>
     *
     * @param resFact 触发规则对象
     * @param packageId 规范规则包
     * @return
     */
    public Object fireRule(Serializable resFact, String packageId) throws Exception
    {
        Map<String, String> map = new HashMap<String, String>();
        map.put("resFact", JSONUtil.toJson(resFact));
        map.put("packageId", packageId);
        map.put("className", resFact.getClass().getName());
        String url = remoteRuleUrl;
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType
                .parseMediaType("application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        HttpEntity<Map<String, String>> formEntity = new HttpEntity<Map<String, String>>(map, headers);
        ResponseEntity responseEntity = restTemplate.exchange(url + "urule/rule/fireRule",
                HttpMethod.POST, formEntity, String.class);

        responseEntity.getBody();
        Map commonResponse = objectMapper.readValue(responseEntity.getBody().toString(),Map.class);
        if (commonResponse != null && commonResponse.get("result").equals(Constants.RESULT_SUCCESS) )
        {
            return commonResponse.get("dataList");
        }
        return null;
    }
    /**
     *
     * <pre>
     * 触发规则流
     * </pre>
     *
     * @param resFact 触发规则对象
     * @param packageId 规范规则包
     * @param processId 规则流id
     * @return
     */
    public Object fireRuleFlow(Serializable resFact, String packageId, String processId)throws Exception
    {
        Map<String, String> map = new HashMap<String, String>();
        map.put("resFact", JSONUtil.toJson(resFact));
        map.put("packageId", packageId);
        map.put("processId", processId);
        map.put("className", resFact.getClass().getName());
        String url = remoteRuleUrl;
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType
                .parseMediaType("application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        HttpEntity<Map<String, String>> formEntity = new HttpEntity<Map<String, String>>(map, headers);

        ResponseEntity responseEntity = restTemplate.exchange(url + "urule/rule/fireRuleFlow",
                HttpMethod.POST, formEntity, String.class);


        Map commonResponse = objectMapper.readValue(responseEntity.getBody().toString(),Map.class);
        if (commonResponse != null && commonResponse.get("result").equals(Constants.RESULT_SUCCESS) )
        {
            return commonResponse.get("dataList");
        }
        return null;
    }
}