package com.yeejoin.amos.patrol.service.remote.feign;

import com.yeejoin.amos.patrol.service.business.util.CacheFactory;
import com.yeejoin.amos.patrol.service.business.util.CacheMap;
import com.yeejoin.amos.patrol.service.business.util.Toke;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.Enumeration;

/**
 * @Author: xinglei
 * @Description: Feign请求拦截器（设置请求头，传递登录信息）
 * @Date: 2020/4/8 10:59
 */
public class RequestContextListener implements RequestInterceptor  {

    @Override
    public void apply(RequestTemplate template) {

        ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder
                .getRequestAttributes();
        if (attributes != null) {
            HttpServletRequest request = attributes.getRequest();
            Enumeration<String> headerNames = request.getHeaderNames();
            if (headerNames != null) {
                while (headerNames.hasMoreElements()) {
                    String name = headerNames.nextElement();
                    String values = request.getHeader(name);
                    template.header(name, values);
                }
            }
        } else {
            //获取缓存
            CacheMap cacheMap= CacheFactory.newChacheMap();
            Toke toke=  cacheMap.getValue("TOKE");
            if (!ObjectUtils.isEmpty(toke)){
                template.header("token", toke.getToke());
                template.header("appKey", toke.getAppKey());
                template.header("product", toke.getProduct());
            }
        }
    }
}
