package com.yeejoin.amos.patrol.service.websocket;


import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import com.yeejoin.amos.patrol.common.entity.CommonResponse;
import com.yeejoin.amos.patrol.service.remote.feign.MultipartSupportConfig;

@FeignClient(name = "AmosWebsocket", configuration={MultipartSupportConfig.class},fallback=AmosWsClientFallback.class)
public interface AmosWsClient {

	@PostMapping("/generic/sendMessage")
    CommonResponse sendMessage(@RequestBody WebsocketParam param);
	
	@PostMapping("/generic/sendDataList")
    CommonResponse sendDataList(@RequestBody WebsocketListParam param);
	
}
