package com.yeejoin.amos.patrol.service.websocket;

import java.util.HashMap;
import java.util.Map;

/**
 * 通用websocket发送消息传递参数
 * @author zhangzhihui
 *
 */
public class WebsocketParam {

	/**
	 * websocket路径，例如：ws://127.0.0.1:10600/zq?orgCode=1*2*3  中的zq
	 */
	private String path;
	
	/**
	 * 发送消息内容
	 */
	private String message;
	
	/**
	 * 正则过滤条件，key为过滤属性名称，value为过滤正则表达式
	 * 用于从多个websocket中根据websocket路径参数筛选符合条件的websocket发送消息
	 */
	private Map<String, String> filter;

	public WebsocketParam() {
		super();
	}

	public WebsocketParam(String path, String message) {
		super();
		this.path = path;
		this.message = message;
	}

	public String getPath() {
		return path;
	}

	public void setPath(String path) {
		this.path = path;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public Map<String, String> getFilter() {
		return filter;
	}

	public void setFilter(Map<String, String> filters) {
		this.filter = filters;
	}
	
	/**
	 * 正则过滤条件，key为过滤属性名称，reg为过滤正则表达式
	 * 用于从多个websocket中根据websocket路径参数筛选符合条件的websocket发送消息
	 * 若有多个条件，则必须全部满足
	 * @param key 例如：ws://127.0.0.1:10600/zq?orgCode=1*2*3  中的orgCode
	 * @param regex 正则表达式，如：1\*2\*3
	 * @return
	 */
	public WebsocketParam addFilter(String key, String regex){
		if(filter==null){
			filter = new HashMap<>();
		}
		filter.put(key, regex);
		return this;
	}
}
