package com.yeejoin.amos;

import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.Environment;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.client.RestTemplate;

import springfox.documentation.swagger2.annotations.EnableSwagger2;

/**
 * <pre>
 * 服务启动类
 * </pre>
 *
 * @author amos
 * @version $Id: YeeAMOSPatrolStart.java, v 0.1 2018年11月26日 下午4:56:29 amos Exp $
 */
@SpringBootApplication
@EnableTransactionManagement
@EnableConfigurationProperties
@EnableSwagger2
@ServletComponentScan
@EnableJpaAuditing
@EnableDiscoveryClient
@EnableFeignClients
@EnableAsync
@EnableEurekaClient
@ComponentScan({"org.typroject","com.yeejoin.amos"})
@MapperScan(basePackages = {"com.yeejoin.amos.patrol.service.business.dao.mapper"})
public class YeeAMOSPatrolStart {

    private static final Logger logger = LoggerFactory.getLogger(YeeAMOSPatrolStart.class);

    
    @Bean
    @LoadBalanced
    RestTemplate initRestTemplate() {
        return new RestTemplate();
    }
    
    
    /**
     * 启动amosop-server
     */
    public static void main(String[] args) {
        ConfigurableApplicationContext context = SpringApplication.run(YeeAMOSPatrolStart.class, args);
        Environment environment = context.getEnvironment();
        
        
        logger.info("The requested service of " + environment.getProperty("spring.application.name")
                + " has already been started in "
                + environment.getProperty("spring.profiles.active") + ""
                + " environment,and service's url is 'http://localhost:"
                + environment.getProperty("server.port") + "/swagger-ui.html'");
    }

//    /**
//     * 获取并缓存上下文
//     */
//    @Override
//    public void setApplicationContext(ApplicationContext applicationContext)
//            throws BeansException {
//        // 缓存spring上下文
//        IotContext.getInstance().setApplicationContext(applicationContext);
//        TriggerKeyQueue.getInstance().start();
//    }
//
//    public static class ApplicationListenerPrepared implements ApplicationListener<ApplicationPreparedEvent> {
//
//        public void onApplicationEvent(ApplicationPreparedEvent arg0) {
//            System.out.println("服务启动成功，开始加载bean...");
//        }
//
//    }
}