DROP TRIGGER IF EXISTS `trigger_check_insert`; 
CREATE trigger trigger_check_insert 
AFTER INSERT ON p_check FOR EACH ROW 
BEGIN
  UPDATE p_route_point SET status =  NEW.is_ok WHERE route_id = NEW.route_id AND point_id = NEW.point_id;
END;

DROP TRIGGER
IF EXISTS `trigger_check_input_insert`;

CREATE TRIGGER trigger_check_input_insert AFTER INSERT ON p_check_input FOR EACH ROW
BEGIN
	UPDATE p_route_point_item
SET STATUS = NEW.is_ok
WHERE
	id = NEW.route_point_item_id;
END;

DROP TRIGGER
IF EXISTS `trigger_route_point_update`;
CREATE TRIGGER trigger_route_point_update AFTER UPDATE ON p_route_point FOR EACH ROW
BEGIN
DECLARE status VARCHAR (50) CHARACTER SET utf8;
DECLARE nuQualifiedCount INT (4);
DECLARE omissionCount INT (4);
SELECT count(1) into nuQualifiedCount FROM p_route_point WHERE point_id = NEW.point_id AND status = '不合格';
SELECT count(1) into omissionCount FROM p_route_point WHERE point_id = NEW.point_id AND status = '漏检';
SET status = NEW. status;
IF status = '不合格' THEN
	UPDATE p_point SET `status` = status WHERE id = NEW.point_id;
END IF;
IF status = '漏检' AND nuQualifiedCount = 0 THEN
		UPDATE p_point SET `status` = status WHERE id = NEW.point_id;
END IF;
IF status = '合格' AND nuQualifiedCount = 0 AND omissionCount = 0 THEN
		UPDATE p_point SET `status` = status WHERE id = NEW.point_id;
END IF;
END;