const menus = {
  textInputItem: { url: '/main/patrol/textInputItem', default: '新增文本检查项', edit: '编辑文本检查项' },
  numberInputItem: { url: '/main/patrol/numberInputItem', default: '新增数字检查项', edit: '编辑数字检查项' },
  choiceInputItem: { url: '/main/patrol/choiceInputItem', default: '新增选择检查项', edit: '编辑选择检查项' },
  newTask: { url: '/main/patrol/newTask', default: '新增任务' },
  detailTask: { url: '/main/patrol/detailTask', default: '任务详情' },
  newRoute: { url: '/main/patrol/newRoute', default: '新增路线' },
  editRoute: { url: '/main/patrol/editRoute', default: '新增路线', edit: '编辑路线'},
  routePoint: { url: '/main/patrol/routePoint', default: '路线巡检点' },
  pointInfoEdit: { url: '/main/patrol/pointInfoEdit', default: '编辑巡检点' },
  pointInfo: { url: '/main/patrol/pointInfo', default: '新增巡检点' },
  planInput: { url: '/main/patrol/planInput', default: '新增巡检计划', edit: '编辑巡检计划' },
  planTask: { url: '/main/patrol/planTask', default: '计划执行' },
  catalogTreeInput: { url: '/main/patrol/catalogTreeInput', default: '新增分类目录', edit: '编辑分类目录' },
  newsadd: { url: '/main/patrol/newsadd', default: '通知发布' },
  completionsituation: { url: '/main/patrol/completionsituation', default: '巡检完成情况月报表' },
  inspectionSituation: { url: '/main/patrol/inspectionSituation', default: '巡检情况统计分析' },
  taskArrangement: { url: '/main/patrol/taskArrangement', default: '任务安排统计分析' },
  personStatistics: { url: '/main/patrol/personStatistics', default: '人员综合统计分析' },
  checkDetail: { url: '/main/patrol/checkDetail', default: '巡检详情' }
};

export default function getLastRoute(key, isDefault) {
  let menu = new Object();
  let temp = menus[key];
  if (temp) {
    menu.url = temp.url;
    if (isDefault) {
      menu.name = temp.default;
    } else {
      menu.name = temp.edit;
      if (!menu.name) {
        menu.name = temp.default;
      }
    }
    return menu;
  }
  return;
}
