// @author ilex.h
import RProgress from 'ray-progress';
import * as endConf from 'amos-processor/lib/config/endconf';
import notFound from 'amos-security/lib/routes/notfound';
import redirect from 'amos-security/lib/routes/notfound/redirect';
import signUp, { signupRouters } from 'amos-security/lib/routes/signUp';
import routerFilter, { checkLogin } from 'amos-security/lib/routes/validateRouter';
import calcRoutes from './calcRoutes';
import addCustomRoutes, { customRoutesMain } from './customRoutes';
import pageCompontent, { RootView, Login, UserInfo, Outter,RegionList } from './view';
import AutoLogin from './../view/autoLogin/AutoLogin';

const AmosConfig = endConf.AmosConfig;
const loginURI = AmosConfig.httpURI.baseURI;


const injectRoutes = (menus) => {


  const mainChilds = addCustomRoutes(calcRoutes(menus, pageCompontent));
  const routes = [
    { path: 'autologin', component: AutoLogin },
    // { path: 'login', component: Login },
    { path: 'outter', component: Outter },
    { path: 'region', component: RegionList }, // 区域选择
    ...signUp,
    {
      path: 'main' ,
      component: RootView,
      childRoutes: [...mainChilds, { path: 'securityConfig', component: UserInfo }, ...customRoutesMain]
    },
    notFound,
    redirect
  ];

  return routes;
};





const onEnterValidate = (next, replace, callback) => {
  progressStart();
  const pathname = next.location.pathname;
  const flag = routerFilter({
    filterPath: [].concat(signupRouters, 'login', 'outter','region', 'autologin'),
    pathname
  });

  if (!checkLogin() && flag ) {
    replace('/login');
  }
  callback();
};

const progressStart = () => {
  RProgress.start();
};

// const rootRoutes = (menus) => {
//   return {
//     path: '/',
//     // onEnter: onEnterValidate,
//     onChange: progressStart,
//     indexRedirect: Login,
//     indexRoute: {
//       onEnter(nextState, replace) {
//         // replace('/login');
//         window.location.href = loginURI;
//       }
//     },
//     childRoutes: injectRoutes(menus)
//   };
// };


const rootRoutes = menus => {
  return {
    path: '/',
    // onEnter: onEnterValidate,
    onChange: progressStart,
    indexRoute: {
      onEnter(nextState, replace) {
        window.location.href = loginURI;
      }
    },
    childRoutes: injectRoutes(menus)
  };
};
export default rootRoutes;
