import * as  _fetch from 'amos-processor/lib/fetch';
import * as utils from 'amos-processor/lib/utils';
import AmosEnum from 'amos-processor/lib/enum/AmosEnum';
import * as permission from 'amos-processor/lib/config/permission';
/**
 * gatherpermissionMenu,
 * mergeMenu,
 * sysConf,
 * filterPermission,
 * checkLevel1Permissions,
 * checkHomePermissions,
 * getSubSystemPermissions
 */

/**
 *
 */
const fetchCallBack = (data, successCallBack, errorCallBack) => {
  if (data && data.result){
    if (data.result === 'SUCCESS') // 成功
    {
      successCallBack && successCallBack(data);
    } else // 失败
    {
      errorCallBack && errorCallBack(data.message ||  data.messageInfo);
    }
  } else {
    successCallBack && successCallBack(data);
  }
};

/**
 *
 */
const fetchToData = (data, type = 'json') => {
  if (data.ok) {
    if (type === 'json') {
      return data.json();
    } else {
      return data.text();
    }
  } else {
    throw new Error('从服务端获取数据失败！');
  }
};

const defaultPageable = {
  page: 0, size: 10
};
// /**
//  * get url特殊字符转译
//  */
// const encodeGetUrl = (url) => {
//   return AmosCommon.encodeUrl(url);
// };

/**
 * 构建分页
 */
const buildPageable = (url, pageable = defaultPageable) => {
  let { page, size } = pageable;
  return `${url}?page=${page}&size=${size}`;
};

export default{
  ..._fetch,
  ...utils,
  AmosEnum,
  ...permission,
  fetchCallBack,
  fetchToData,
  buildPageable
};
