import { trim } from 'amos-tool';

const normalLength = 32;

export const formRules = {
  select: [{
    required: true, message: '必选项'
  }],
  input: (length = normalLength) => {
    return [{
      required: true, message: '必填项'
    },{
      validator: (rule, value,callback)=> {
        if (trim(value).length < length && trim(value).length > 0){
          callback();
        } else {
          callback(new Error(`长度不能大于${length}且不能为空`));
        }
      }
    }];
  },
  maxInput: (length = normalLength) => {
    return [{
      validator: (rule, value,callback)=> {
        if (trim(value).length < length){
          callback();
        } else {
          callback(new Error(`长度不能大于${length}`));
        }
      }
    }];
  },
  longChart: 255
};

export const isEmpty = (value) => {
  if (!value && value !== 0) {
    return true;
  } else {
    if (trim(`${value}`)) {
      return false;
    } else {
      return true;
    }
  }
};
/**
 * 过滤对象中字符串的前后空格
 * @param {*} form
 */
export const trimFormData = (form) => {
  for (let key in form) {
    if ((typeof form[key] === 'string') && form[key].constructor === String) {
      form[key] = trim(form[key]);
    }
  }
  return form;
};

/**
 * 文本输入框的字符输入长度限制
 * length 限制的长度
 *
 * import {textLengthValidate} from 'UTILS/validate';
 * rules: [{ validator: textLengthValidate(20) } ] 长度不能大于20
 * rules: [{ validator: textLengthValidate(20,1) } ] 长度不能大于20 长度不能小于1
 */
export const textLengthValidate = (maxLength, minLength) => {
  return (rule, value, callback) => {
    if (value){
      if (trim(value).length > maxLength){
        callback(`长度不能大于${maxLength}`);
      } else {
        if (minLength && trim(value).length < minLength){
          callback(`长度不能小于${minLength}`);
        } else {
          callback();
        }
      }
    }
    callback();
  };
};

/**
 * 对象中的字符串属性进行trim
 */
export const objOfStrPropTrim = (values) => {
  if (typeof values === 'object'){
    let keys = Object.keys(values);
    keys.forEach(e=>{
      if (typeof values[e] === 'string'){
        values[e] = trim(values[e]);
      }
    });
  }
  return values;
};

/**
 * 對輸入的數字進行最大值和最小值的限制
 */
export const textValueValidate = (maxValue,minValue) => {
  return (rule, value, callback) => {
    if (value){
      if (/^-?\d+\.?\d*$/.test(value)){
        if (value > maxValue){
          callback(`输入的值不能大于${maxValue}`);
        } else {
          if (minValue && minValue < maxValue && value < minValue){
            callback(`输入的值不能小于${minValue}`);
          } else {
            callback();
          }
        }
      } else {
        callback('请输入正确的数值格式');
      }
    }
    callback();
  };
};

/**
 * 限制输入的第一位数不能为0
 */
export const textFirstValueValidate = (minLength) => {
  return (rule, value, callback) => {
    if (value){
      if (/^[1-9]\d*$/.test(value)){
        if (minLength && trim(value).length < minLength){
          callback(`长度不能小于${minLength}`);
        }
      } else {
        callback('输入的值第一位不能为0');
      }
    }
    callback();
  };
};

/**
 * 限制输入的值为数字且不能小于0
 */
export const textIsNumValidate = (minValue) => {
  return (rule, value, callback) => {
    if (value){
      if (/^-?\d+\.?\d*$/.test(value)){
        if (minValue && value < minValue){
          callback(`输入的值不能小于${minValue}`);
        } else {
          callback();
        }
      } else {
        callback('只能输入数字');
      }
    }
    callback();
  };
};


 /**
   * 校验数字长度和格式
   */
export const intLengthValidate = (maxLength, minLength) => {
  return (rule, value, callback) => {
    if (value){
      if (/^-?\d+\.?\d*$/.test(value)){
        if (trim(value).length > maxLength){
          callback(`长度不能大于${maxLength}`);
        }
      } else {
        callback('请输入正确的数值格式');
      }
    }
    callback();
  };
};

/**
 * 验证正整数
 */
export const isPositiveInteger = function(value) {
  if (isInt(value)) {
    if (Number(value) >= 0) {
      return true;
    }
  } else {
    return false;
  }
  return false;
};

const integerMinValue = -2147483648;
const integerMaxValue = 2147483647;
/**
 * 验证INT值
 */
export const isInt = function(value) {
  if (/^0$|^[1-9]\d*$/.test(value)) {
    const val = Number(value);
    if (val <= integerMinValue && val >= integerMaxValue) {
      return false;
    }
    return true;
  } else {
    return false;
  }
};
/**
 * 验证LONG值
 */
export const isLong = function(value) {
  if (/^0$|^[1-9]\d*$/.test(value)) {
    return true;
  } else {
    return false;
  }
};
/**
 * 验证DOUBLE值
 */
export const isDouble = function(value) {
  if (/^[-\+]?\d+(\.\d+)?$/.test(value)) {
    return true;
  } else {
    return false;
  }
};
/**
 * 验证FLOAT值
 */
export const isFloat = function(value) {
  if (/^[-\+]?\d+(\.\d+)?$/.test(value)) {
    return true;
  } else {
    return false;
  }
};
/**
 * 验证Date值
 */
export const isDate = function(value) {
  let reg = /^[1-9]\d{3}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/;
  let regExp = new RegExp(reg);
  if (regExp.test(value)){
    return true;
  } else {
    return false;
  }
};

/**
 * 验证变量名，以字符或中文开头，长度在1-30之间，只能包含字符、数字、中文和下划线，且不能为关键字
 */
export const isName = function(value) {
  let reg = /^([A-Za-z]|[^u4E00-u9FA5])[\da-zA-Z_\u4e00-\u9f5a]{0,29}$/;
  let regExp = new RegExp(reg);
  value = trim(value);
  if (regExp.test(value)) {
    return true;
  } else {
    return false;
  }
};
