import React, { Component } from 'react';
import PropTypes from 'prop-types';
import moment from 'moment';
import { Popover, Input,Icon } from 'amos-framework';
import './style/yearPicker.scss';

/**
 *
 * 年日历组件
 * @class YearPicker
 * @extends {Component}
 */
const rowNum = 4;//行数
const column = 3;//列数
const defaultNum = 11;//默认选择时间位置
class YearPicker extends Component {
  constructor(props) {
    super(props);
    this.state = {
      yearDate: moment().format('YYYY'),
      chooseYear: '',
      open: false,
      defaultWidth: '20rem',
      checkdPositon: defaultNum//默认选择位置
    };
  }

  componentWillMount() {
    const { defaultValue } = this.props;
    defaultValue && this.setState({ yearDate: moment(defaultValue).format('YYYY') });
  }

  componentDidMount() {

  }

  onDateClick =(e,value)=>{
    e.stopPropagation();
    const { yearDate } = this.state;
    let beginYear = yearDate - defaultNum + 1;
    let endYear = parseInt(yearDate) + (rowNum*column - defaultNum);
    let chooseYear = value;
    if (chooseYear === beginYear) {//修改日历并回填
      this.setState({ yearDate: chooseYear,checkdPositon: defaultNum });
    } else if (chooseYear === endYear) {//修改日历并回填
      this.setState({ yearDate: parseInt(yearDate) + 10,chooseYear,checkdPositon: defaultNum });
    } else {//日期回填
      this.setState({ chooseYear,checkdPositon: chooseYear - beginYear + 1 });//选择日期的坐标行列计算
    }
    const { onChange } = this.props;
    onChange && onChange(chooseYear); //日期回调
    this.setState({ open: false });
  }

  onPreClick =(e)=>{
    e.stopPropagation();
    const { yearDate,open } = this.state;
    open ? this.setState({ yearDate: yearDate - 10 }) : this.setState({ yearDate: yearDate - 10,open: true });
  }


  onNextClick =(e)=>{
    e.stopPropagation();
    const { yearDate,open } = this.state;
    open ? this.setState({ yearDate: parseInt(yearDate) + 10 }) : this.setState({ yearDate: parseInt(yearDate) + 10 ,open: true });
  }

  clearInputValue =()=>{
    this.setState({ chooseYear: '' });
    const { onChange } = this.props;
    onChange && onChange(''); //日期回调
  }

  renderDownContent =(yearDate)=>{
    let beginYear = yearDate - defaultNum + 2;
    return (<div className='year-picker'>
      <div className='year-picker-header'>
        <div className='prev-decade-btn' onClick={e=>this.onPreClick(e)} />
        <div className='year-decade-content'>{beginYear}-{yearDate}</div>
        <div className='next-decade-btn' onClick={e=>this.onNextClick(e)} />
      </div>
      <div className='year-picker-body'>
        {this.renderYearBody(yearDate)}
      </div>
    </div>);
  }

  renderYearBody =(yearDate)=>{
    return (<table className='year-picker-table'>
      <tbody>{this.renderRow(yearDate)}</tbody>
    </table>);
  }

  renderRow =(yearDate)=>{
    let rowArry = [];
    let beginYear = yearDate - defaultNum + 1;
    for (let i = 1 ;i <= rowNum;i++ ){
      let rowBegin = beginYear + 3*(i - 1);
      rowArry.push(
        <tr>
          {this.renderColumn(rowBegin)}
        </tr>
      );
    }
    return rowArry;
  }

  renderColumn =(beginYear)=>{
    let columnArry = [];
    const { disabledDate } = this.props;
    for (let i = 1 ;i <= column;i++){
      let year = beginYear + i - 1;
      let disabled = disabledDate && disabledDate(year) ? true : false;
      columnArry.push(
        <td><div className='year-picker-td-cxt' style={disabled ?  { cursor: 'not-allowed',background: '#f5f5f5' } : {}} onClick={disabled ? e=>{e.stopPropagation;} : e=>this.onDateClick(e,year)}>{year}</div></td>
      );
    }
    return columnArry;
  }

  render() {
    const { chooseYear, yearDate,open,defaultWidth } = this.state;
    const { value,width,isEmpty = false,allowClear = false } = this.props;
    return (
      <div style={{ display: 'inline-block' }}>
        <div ref={node => this.container = node} className="year-picker-container" />
        <Popover
          content={this.renderDownContent(yearDate)}
          direction="down"
          triggerMode="click"
          destroyContent
          getPopContainer={() => this.container}
          aligned
          open={open}
          contentWrapClassName='year-picker-popover'
        >
          <span className='year-picker-line'>
            <Input value={isEmpty ? '' : (value || chooseYear)} style={{ width: width ? width : defaultWidth }} />
            {allowClear && <Icon icon="cancel" className='year-picker-icon-clear' onClick={this.clearInputValue} />}
          </span>
        </Popover>
      </div>
    );
  }
}

YearPicker.propTypes = {
  onChange: PropTypes.func,
  disabledDate: PropTypes.func,
  value: PropTypes.any,
  defaultValue: PropTypes.any,
  width: PropTypes.any,
  isEmpty: PropTypes.bool,
  allowClear: PropTypes.bool
};

export default YearPicker;
