import { Component } from 'react';
import PropTypes from 'prop-types';
import { seachPermissionAction } from './../../../services/checkService';

/**
 * 权限控制
 *
 * @class HasPermission
 * @extends {Component}
 */
class HasPermission extends Component{
  constructor(props) {
    super(props);
    this.state = {
      isWriteable: false
    };
  }

  componentWillMount() {
    const { permissionCode } = this.props;
    const permissionsMenus = window.localStorage.getItem('permissionsMenus');
    
    let data = [];
    if (permissionsMenus) {
      data = JSON.parse(permissionsMenus);
    }
    let children = [];
    if (data && permissionCode) {
      data.find(item => {
        // if (item.label === '巡检业务'){
        if (item.permissionName === '巡检业务'){
          children = item.children;
          if(children&&children.length>0){
            let menu = children.find(item => {
              if (void 0 === permissionCode) {
                return true;
              }
              // return permissionCode === item.permissionCode;
              return permissionCode === item.frontComponent;
            });

            if (!menu) {
              return;
            }
          }
          
         
          // this.setState({ isWriteable: menu.isWriteable });
          this.setState({ isWriteable: true });
        }
      });
    }
 }

  getRender = () => {
    const { isWriteable } = this.state;
    if (isWriteable) {
      return this.props.children;
    } else {
      return '';
    }
  }

  render() {
    return this.getRender();
  }
}

HasPermission.propTypes = {
  children: PropTypes.node,
  permissionCode: PropTypes.string
};

export default HasPermission;
