import React, { Component } from 'react';
import Login from 'amos-security/lib/view/login/LoginWithSignup';
import Footer from './Footer';
import { browserHistory } from 'amos-react-router';
import { Store } from 'amos-tool';
import { Icon } from 'amos-framework';
import { regionSelectFlag } from './../../consts/commonConsts'
// import AlgorithmEditor from './../../sysextend/ma/view/algorithm/editor';

const inputData = [
  { name: '训练集1', code: 'input1', columns: [
    { alias: '批次 ID', type: 'STRING', role: 'label' },
    { alias: 'pH', type: 'DOUBLE', role: 'regular' }
  ] }
];
const lsTool = Store.lsTool;

class LoginComponent extends Component {
  constructor(props) {
    super(props);
    this.state = {
      display: 'none'
    };
  }

  componentWillMount(){
    lsTool.remove(regionSelectFlag);
    window.setLoading = (flag) => {};
  }

  goto = () => {
    browserHistory.push('/region');
  };

  onMouseLeave =()=>{
    this.setState({ display: 'none' });
  }

  onMouseOver =()=>{
    this.setState({ display: 'block' });
  }

  render() {
    const desict = (
      <div />
    );
    // window.isDisplayQR 是否显示二维码及注销功能
    return (
      <div className="login">
        {window.isDisplayQR ? <div className='down-address'>
          <Icon  prefix='amosicon' icon="shouji" style={{ display: 'inline-block',fontSize: 15, color: 'white' }} />
          <span className="down-front"  onMouseLeave={this.onMouseLeave} onMouseOver={this.onMouseOver} >&nbsp;APP下载&nbsp;</span>
          <Icon icon="down" style={{ display: 'inline-block',fontSize: 15, color: 'white' }} />
          <img src='/src/assets/auth/appUpload.png' alt='' style={{ display: this.state.display }} />
        </div> : null}
        <Login
          logo="/src/assets/auth/logo.png"
          title="智能巡检平台"
          showVerifyCode={false}
          desicOne={null}
          desictTow={desict}
          goto={this.goto}
          footer={<Footer />}
        />
      </div>
    );
  }
}

LoginComponent.propTypes = {

};

export default LoginComponent;
