import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import { Link } from 'amos-react-router';
import { Scrollbars } from 'amos-framework';
import Icon from 'amos-icon';

import { Menu } from 'amos-antd';

import ThemeConsts from '../../consts/themeConsts';

const SubMenu = Menu.SubMenu;
/**
 * root
 *
 * @class SiderMenus
 * @extends {Component}
 */
class SiderMenus extends Component {
  static propTypes = {
    siderMenusList: PropTypes.array,
    collapsed: PropTypes.bool,
    selectedSubMenuKey: PropTypes.string
  };

  static defaultProps = {
    siderMenusList: []
  };

  constructor(props) {
    super(props);
    this.state = {
      selectedKeys: []
    };
  }

  componentWillMount() {}

  componentDidMount() {
    this.dealDefaultKey(this.props.siderMenusList);
  }

  componentWillReceiveProps(nextProps) {
    if (nextProps.siderMenusList !== this.props.siderMenusList) {
      this.dealDefaultKey(nextProps.siderMenusList);
    }
  }

  onSelect = ({ item, key, selectedKeys }) => {
    this.setState({ selectedKeys: [key] });
  };

  dealDefaultKey = siderMenusList => {
    let { selectedSubMenuKey } = this.props;
    let defaultKey = '';
    if (location && location.query && location.query.key) {
      defaultKey = location.query.key;
    }
    const getKey = list => {
      list.map(e => {
        if (defaultKey) {
          return;
        }
        if (e.children && e.children.length > 0) {
          getKey(e.children);
        } else {
          defaultKey = e.key;
        }
      });
    };
    if (selectedSubMenuKey !== undefined && selectedSubMenuKey !== '') {
      if (siderMenusList.filter(i => i.key === selectedSubMenuKey).length === 1) {
        defaultKey = selectedSubMenuKey;
      }
    }
    getKey(siderMenusList);
    this.setState({ selectedKeys: [defaultKey] });
  };

  renderImage = menu => {
    if (menu.icon) {
      return <Icon className="amos-sider-menus-item-icon" icon={menu.icon} color={ThemeConsts[window.CheckDefaultTheme]} />;
    } else {
      return <img className="amos-sider-menus-item-img" src={menu.image} alt="" />;
    }
  };

  renderItem = menu => {
    if (menu.children && menu.children.length > 0) {
      return (
        <SubMenu
          key={menu.path}
          title={
            <span>
              {this.renderImage(menu)}
              <span className="sidebar-title-text">{menu.permissionName}</span>
            </span>
          }
        >
          {menu.children.map(e => this.renderItem(e))}
        </SubMenu>
      );
    } else {
      return (
        <Menu.Item key={menu.path}>
          <Link to={menu.path}>
            {this.renderImage(menu)}
            <span className="sidebar-title-text">{menu.permissionName}</span>
          </Link>
        </Menu.Item>
      );
    }
  };

  render() {
    let { siderMenusList, collapsed } = this.props;
    // let { selectedKeys } = this.state;
    siderMenusList = siderMenusList || [];
    const _class = classnames('amos-sider-menus-content', {
      hide: collapsed
    });
    let pathname = (window.location.pathname || '').split('?')[0];
    return (
      <Scrollbars>
        <Menu onSelect={this.onSelect} inlineCollapsed={collapsed} mode="inline" className={_class} selectedKeys={[pathname]}>
          {siderMenusList.map(e => this.renderItem(e))}
        </Menu>
      </Scrollbars>
    );
  }
}

export default SiderMenus;
