import React, { Component } from 'react';
import FreeLogin from 'amos-security/lib/view/login/FreeLogin';
import { Store } from 'amos-tool';
import { browserHistory } from 'amos-react-router';
import { regionSelectFlag } from './../../consts/commonConsts';
import { saveCurCompanyAction } from './../../services/regionService';

const lsTool = Store.lsTool;
/**
 * 厂区选择
 *
 * @class Outter
 * @extends {Component}
 */
class Outter extends Component {

  onRegionSelect = (orgCode) => {
    saveCurCompanyAction(orgCode).then(data =>{
      browserHistory.push('/main/patrol');
    });
  }

  goto = () => {
    const isSub = this.props.location.query.isSub;
    const orgCode = this.props.location.query.orgCode;
    if (isSub) {
      lsTool.write(regionSelectFlag, '1');
      window.localStorage.setItem('isSub', isSub);
      this.onRegionSelect(orgCode);
    } else {
      if (orgCode) {
        this.onRegionSelect(orgCode);
      } else {
        browserHistory.push('/region');
      }
    }
  }

  render() {
    const user = this.props.location.query.user;
    const token = this.props.location.query.token;
    const regionSelect = this.props.location.query.region;
    const path = 'region';
    lsTool.write(regionSelectFlag, regionSelect);

    return (
    <FreeLogin
      goto={this.goto}
      user={user}
      token={token}
    />
    );
  }
}

export default Outter;
