import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { TreeSelect } from 'amos-antd';
import { Form, Input, Button } from 'amos-framework';
import './../../../styles/view/patrol/inputItem.scss';
import { queryCatalogTreeAction } from '../../../services/checkService';

const FormItem = Form.Item;

/**
 * 分类树查询
 *
 * @class CheckSearch
 * @extends {Component}
 */
class CheckSearch extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        name: {
          name: 'name',
          value: ''
        },
        parentId: {
          name: 'parentId',
          value: ''
        }
      },
      treeData: []
    };
  }

  componentWillMount = () => {
    // this.queryCatalogTree();
  };

  componentWillReceiveProps(nextProps) {
    this.setState({
      treeData: nextProps.treeData
    });
  }

  onChange = (key, e) => {
    let { form } = this.state;
    form[key].value = e.target.value;
    this.setState(form);
  };

  onSelectChange = (key, value) => {
    let { form } = this.state;
    form[key].value = value;
    this.setState(form);
  };

  // queryCatalogTree = () => {
  //   queryCatalogTreeAction().then(data => {
  //     let treeData = data;
  //     this.setState({ treeData });
  //   });
  // };

  handleSubmit = () => {
    let { form } = this.state;
    const param = { pageNumber: 0, pageSize: 10 };
    this.props.search(form, param);
  };

  render() {
    const { form, treeData } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 4 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    return (
      <Form style={{ padding: '30px 0 0 0' }} className="basic-demo" model={form}>
        <FormItem label={<span>名称</span>} field="name" {...formItemLayout}>
          <Input prefixCls="" value={form.name.value} className="search_Input" onChange={e => this.onChange('name', e)} />
        </FormItem>
        <Input className="input_hide"/>
        <FormItem label={<span>上级目录</span>} field="parentId" {...formItemLayout}>
          <TreeSelect
            value={form.parentId.value}
            allowClear
            className="catalog-search_Input"
            dropdownStyle={{ maxHeight: 400, overflow: 'auto' }}
            treeData={treeData}
            placeholder="请选择"
            treeDefaultExpandAll
            onChange={e => this.onSelectChange('parentId', e)}
          />
        </FormItem>
        <FormItem className="search-btn">
          <Button icon="search" onClick={this.handleSubmit}>
            查询
          </Button>
        </FormItem>
      </Form>
    );
  }
}

CheckSearch.propTypes = {
  search: PropTypes.func,
  treeData: PropTypes.array
};

export default CheckSearch;
