import { Icon, Button } from 'amos-framework';
import React, { Component } from 'react';
import  '../../../styles/view/component/drawer.scss';
import PropTypes from 'prop-types';

/**
 * 巡检项
 *
 * @class InputItemSearch
 * @extends {Component}
 */
class SplitLayout extends Component{
  state = {
    content: {
      right: '0px',
      display: 'block'
    },
    client: {
      right: '300px',
      display: 'none'
    }
  };

  changeStatus = (e) => {
    const { content } = this.state;
    if (content.right !== '0px') {
      let ClientContent = {
        right: '0px',
        display: 'block'
      };
      let newClient = {
        right: '300px',
        display: 'none'
      };
      this.setState({ content: ClientContent, client: newClient });
    } else {
      let ClientContent = {
        right: '-250px',
        opacity: 'block'
      };
      let newClient = {
        right: '0px',
        opacity: 'show',
        display: 'block'
      };
      this.setState({ content: ClientContent, client: newClient });
    }
  }

  render() {
    const { content, client } = this.state;
    const { title } = this.props;
    return (
      <div className="qq-client-body">
        <div style={client} className="qq-client">
          <a onClick={this.changeStatus} className="qq-client-open" style={client} >
            <Icon size="1x"  prefix="amosicon" icon="gengduo2" />
          </a>
        </div>
        <div className="qq-client-content" style={content}>
          <h2>
            {title}
          </h2>
          <div className="qq-client-open-content">
            {this.props.children}
          </div>
        </div>
      </div>
    );
  }
}

SplitLayout.propTypes = {
  children: PropTypes.node,
  title: PropTypes.string
};

export default SplitLayout;
