import React, { Component } from 'react';
import PropTypes from 'prop-types';
import AmosEcharts from 'amos-viz/lib/echarts';

/**
 * 巡检首页-图表
 *
 * @class PatrolChart
 * @extends {Component}
 */
class PatrolChart extends Component {
  constructor(props) {
    super(props);

  }

  getOption = () => {
    const { data } = this.props;
    const { xAxis, check, plan, missed } = data || {};
    return {
      grid: {
        right: '30px',
        left: '70px',
        top: '25px',
        bottom: '30px'
      },
      tooltip: {
        trigger: 'axis',
        axisPointer: {
          type: 'shadow'
        }
      },
      legend: {
        icon: 'rect',
        itemWidth: 14,
        itemHeight: 5,
        itemGap: 13,
        data: ['实际巡检', '计划巡检', '漏检次数'],
        bottom: 0
      },
      xAxis: {
        data: xAxis,
        axisLabel: {
          interval: 0,
          show: true,
          textStyle: {
            // color: 'white'
          }
        },
        axisLine: {
          lineStyle: {
            show: false,
            color: '#494d54',
            width: 1
          }
        }
      },
      yAxis: [{
        type: 'value',
        name: '巡检次数',
        nameGap: 40,
        nameLocation: 'middle',
        nameTextStyle: {
          'color': '#AEA4A8'
        },
        axisLabel: {
          interval: 0,
          show: true
        },
        axisLine: {
          show: false
        },
        axisTick: {
          show: false
        },
        splitLine: {
          lineStyle: {
            color: '#e6e6e6',
            width: 1
          }
        }
      }
      ],
      series: [{
        name: '实际巡检',
        type: 'line',
        silent: true,
        barGap: 0,
        barWidth: '30%',
        label: {
          normal: {
            show: true,
            position: 'top',
            color: 'black',
            align: 'center'
          }
        },
        itemStyle: {
          normal: {
            color: '#5cb85c'
          }
        },
        data: check
      },{
        name: '计划巡检',
        type: 'line',
        silent: true,
        barGap: 0,
        barWidth: '30%',
        label: {
          normal: {
            show: true,
            position: 'top',
            color: 'black',
            align: 'center'
          }
        },
        itemStyle: {
          normal: {
            color: '#337ab7'
          }
        },
        data: plan
      },{
        name: '漏检次数',
        type: 'line',
        silent: true,
        barGap: 0,
        barWidth: '30%',
        label: {
          normal: {
            show: true,
            position: 'top',
            color: 'black',
            align: 'center'
          }
        },
        itemStyle: {
          normal: {
            color: '#d9534f'
          }
        },
        data: missed
      }]
    };
  }

  render() {
    return (
      <div className="patrol-home-chart">
        <AmosEcharts option={this.getOption()} />
      </div>
    );
  }
}

PatrolChart.propTypes = {
  data: PropTypes.object
};


PatrolChart.defaultProps = {
  data: []
};


export default PatrolChart;
