import { Table, Button } from 'amos-antd';
import React, { Component } from 'react';

import PropTypes from 'prop-types';

/**
 * 图片选择table
 *
 * @class CommonTable
 * @extends {Component}
 */
class CommonTablexq extends Component {
  constructor(props) {
    super(props);
    this.state = {
      data: [],
      selectedRowKeys: [],
      selectedRows: []
    };
  }
  /**
   * 组件初始化调用
   */
  componentWillMount = () => {
    const { tableData } = this.props;
    this.props.onChangeTableValues(tableData);
  };

  componentWillReceiveProps = nextProps => {
    if (nextProps.tableData) {
      const { tableData, moreData } = nextProps || {};
      let temp = [];
      const { data } = this.state;
      if (moreData) {
        moreData.map(item => {
          let tempLength = data.length;
          item.orderNo = tempLength > 0 ? (data[tempLength - 1].orderNo + 1) : 0;
          temp = data.push(item);
        });
      }
      temp = data;
      this.setState({ data: temp.length === 0 ? tableData : temp });
    }
  };

  onRowChanger = (selectedRowKeys, selectedRows) => {
    this.setState({ selectedRowKeys, selectedRows });
  };

  onUpClick = e => {
    let { data, selectedRows, selectedRowKeys } = this.state;
    for (let i = 0; i < selectedRows.length; i++) {
      let minOrderNo = 0;
      let srcNo = selectedRows[i].orderNo;
      if (srcNo <= 0) {
        break;
      }
      let des = data[srcNo];
      des.orderNo = des.orderNo - 1;
      let src = data[srcNo - 1];
      src.orderNo = src.orderNo + 1;
      data[srcNo] = src;
      data[srcNo - 1] = des;
      selectedRows[i] = des;
      selectedRowKeys[i] = selectedRowKeys[i] - 1;
    }
    this.setState({ data, selectedRows, selectedRowKeys }, () => this.props.onChangeTableValues(data));
  };

  onDownClick = e => {
    let { data, selectedRows, selectedRowKeys } = this.state;
    for (let i = selectedRows.length - 1; i >= 0; i--) {
      let maxOrderNo = data.length - 1;
      let srcNo = selectedRows[i].orderNo;
      if (srcNo >= maxOrderNo) {
        break;
      }
      let des = data[srcNo];
      des.orderNo = des.orderNo + 1;
      let src = data[srcNo + 1];
      src.orderNo = src.orderNo - 1;
      data[srcNo + 1] = des;
      data[srcNo] = src;
      selectedRows[i] = des;
      selectedRowKeys[i] = selectedRowKeys[i] + 1;
    }
    this.setState({ data, selectedRows, selectedRowKeys }, () => this.props.onChangeTableValues(data));
  };

  onDelClick = e => {
    let { data, selectedRows, selectedRowKeys } = this.state;
    for (let i = 0; i < selectedRows.length; i++) {
      // alert(JSON.stringify(selectedRows[i]));
      // alert(selectedRows[i].orderNo);
      data.splice(data.findIndex(item => item.orderNo === selectedRows[i].orderNo), 1);
    }
    for (let i = 0; i < data.length; i++){
      data[i].orderNo =  i;
    }
    this.setState({ data, selectedRows: [], selectedRowKeys: [] }, () => this.props.onChangeTableValues(data));
  };
  onAddClick = e => {
    let { data } = this.state;
    let maxNo = data.length;
    if (!maxNo) {
      maxNo = 0;
    }
    let row = new Object();
    row.orderNo = maxNo;
    data.push(row);
    this.setState({ data }, () => this.props.onChangeTableValues(data));
  };

  onDoubleClick = (record, event) => {
    const { data } = this.state;
    for (let i = 0; i < data.length; i++) {
      if (record.orderNo === data[i].orderNo) {
        data[i].edit = true;
      } else {
        data[i].edit = false;
      }
    }
    this.props.onChangeTableValues(data);
  };
  /**
   * 获取表格工具栏
   */
  getHeader = () => {
    const { addHide } = this.props;

    return !addHide ? (
      <div>
        <Button onClick={this.onAddClick} icon="add">
          添加
        </Button>
        <Button onClick={this.onDelClick} icon="remove">
          删除
        </Button>
        <Button onClick={this.onUpClick} icon="up-circle">
          上移
        </Button>
        <Button onClick={this.onDownClick} icon="down-circle">
          下移
        </Button>
      </div>
    ) : (
      <div>
        <Button onClick={this.onUpClick} icon="up-circle">
          上移
        </Button>
        <Button onClick={this.onDownClick} icon="down-circle">
          下移
        </Button>
        <Button onClick={this.onDelClick} icon="remove">
          删除
        </Button>
      </div>
    );
  };

  /**
   * 获取表格表头
   */
  getTablecolumns = () => {
    const { columns } = this.props;
    return columns;
  };

  render() {
    let pagination = false;
    let { data, selectedRowKeys } = this.state;
    const { scroll } = this.props;
    const rowSelection = {
      selections: {
        key: 'orderNo'
      },
      selectedRowKeys,
      onChange: (selectedRowKeys, selectedRows) => {
        this.onRowChanger(selectedRowKeys, selectedRows);
      }
    };

    return (
      <div>
        <Table
          rowKey={(record, index) => record.orderNo}
          rowSelection={rowSelection}
          columns={this.getTablecolumns()}
          dataSource={data}
          pagination={pagination}
          bordered
          // title={() => this.getHeader()}
          onRowClick={this.onDoubleClick}
          scroll={scroll || {}}
        />
      </div>
    );
  }
}

CommonTablexq.propTypes = {
  tableData: PropTypes.array,
  onChangeTableValues: PropTypes.func,
  columns: PropTypes.array,
  scroll: PropTypes.object,
  addHide: PropTypes.bool
};

export default CommonTablexq;
