import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { DatePicker } from 'amos-antd';
import moment from 'moment';
import { Form, Input, Button, Select } from 'amos-framework';
import { newsTypeListAction } from './../../../services/newsService';

const FormItem = Form.Item;
const Option = Select.Option;


/**
 * 消息提醒执行查询
 *
 * @class NewsSearch
 * @extends {Component}
 */
class NewsSearch extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        startTime: {
          name: 'startTime',
          value: moment()
            .startOf('day')
            .format('YYYY-MM-DD HH:mm:ss')
        },
        endTime: {
          name: 'endTime',
          value: moment()
            .endOf('day')
            .format('YYYY-MM-DD HH:mm:ss')
        },
        username: { name: 'userName', value: '', type: 'LIKE' },
        msgType: { name: 'msgType', value: '' }
      },
      newsTypeList: []
    };
  }

  componentWillMount = () => {
    this.queryNewsTypeList();
  };

  onChange = (key, e) => {
    let { form } = this.state;
    form[key].value = e.target.value;
    this.setState(form);
  };

  onDateChange = (key, date) => {
    const { form } = this.state;
    form[key].value = moment(date).format('YYYY-MM-DD HH:mm:ss');
    this.setState({ form });
  };

  onSelectChange = (key, value) => {
    let { form } = this.state;
    form[key].value = value;
    this.setState(form);
  };

  queryNewsTypeList = () => {
    newsTypeListAction().then(data => {
      this.setState({ newsTypeList: data.map(e => {
        return { id: Object.keys(e)[0], name: Object.values(e)[0] };
      }) });
    });
  };

  handleSubmit = () => {
    let { form } = this.state;
    const param = { pageNumber: 0, pageSize: 10 };
    this.props.search(form, param);
  };

  render() {
    const { form, newsTypeList } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 4 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    return (
      <Form style={{ padding: '30px 0 0 0' }} className="basic-demo" model={form}>
        <FormItem label={<span>开始日期</span>} field="startTime" {...formItemLayout}>
          <DatePicker
            className="search_Input"
            value={moment(form.startTime.value)}
            allowClear={false}
            format="YYYY-MM-DD HH:mm:ss"
            onChange={e => this.onDateChange('startTime', e)}
          />
        </FormItem>
        <FormItem label={<span>结束日期</span>} field="endTime" {...formItemLayout}>
          <DatePicker
            className="search_Input"
            value={moment(form.endTime.value)}
            allowClear={false}
            format="YYYY-MM-DD HH:mm:ss"
            onChange={e => this.onDateChange('endTime', e)}
          />
        </FormItem>
        <FormItem label={<span>消息类型</span>} field="msgType" {...formItemLayout}>
          <Select
            data={newsTypeList}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            defaultOption={<Option value="">全部</Option>}
            value={form.msgType.value}
            className="search_Input"
            onChange={e => this.onSelectChange('msgType', e)}
          />
        </FormItem>
        <FormItem label={<span>用户名称</span>} field="username" {...formItemLayout}>
          <Input prefixCls="" value={form.username.value} className="search_Input" onChange={e => this.onChange('username', e)} />
        </FormItem>
        <FormItem className="search-btn">
          <Button icon="search" onClick={this.handleSubmit}>
            查询
          </Button>
        </FormItem>
      </Form>
    );
  }
}

NewsSearch.propTypes = {
  search: PropTypes.func
};

export default NewsSearch;
