import React, { Component } from 'react';
// import PropTypes from 'prop-types';
import moment from 'moment';
import SplitterLayout from '../../component/SplitLayout';
import { getNewsListAction } from '../../../services/newsService';
import NewsSearch from './NewsSearch';
import NewsTable from './NewsTable';
/**
 * 消息提醒
 *
 * @class News
 * @extends {Component}
 */
class News extends Component {
  constructor(props) {
    super(props);
    this.state = {
      searchParam: [],
      newsData: [],
      totalCount: 0
    };
  }

  componentWillMount = () => {
    let { searchParam } = this.state;
    let beginToday = moment(new Date()).format('YYYY-MM-DD') + ' 00:00:00';
    let endToday = moment(new Date()).format('YYYY-MM-DD') + ' 23:59:59';
    searchParam.push({ name: 'startTime', value: beginToday });
    searchParam.push({ name: 'endTime', value: endToday });
    this.setState({ searchParam });

  };

  onSearchDataSyn = (queryParam, param) => {
    let quest = [];
    if (queryParam) {
      for (let key in queryParam) {
        let obj = queryParam[key];
        quest.push(obj);
      }
    }
    this.setState({ searchParam: quest }, () => {
      this.questNewsData(param);
    });
  };

  questNewsData = param => {
    let { searchParam } = this.state;
    if (param.current != null) {
      //前端的current 即后端的pageNumber
      param.pageNumber = param.current;
    }
    let { pageNumber, pageSize } = param;
    this.queryNewsInfo(searchParam, pageNumber, pageSize);
  };

  queryNewsInfo(searchParam, pageNumber, pageSize) {
    getNewsListAction(searchParam, pageNumber, pageSize).then(data => {
      let statisticsData = data.content;
      let totalCount = data.totalElements;
      this.setState({
        newsData: statisticsData,
        totalCount
      });
    });
  }

  render() {
    const { newsData, totalCount } = this.state;
    return (
      <div className="patrol-page-content">
        <SplitterLayout>
          <NewsSearch search={this.onSearchDataSyn} />
        </SplitterLayout>
        <NewsTable count={totalCount} fetchData={this.questNewsData} dataList={newsData} />
      </div>
    );
  }
}

export default News;
