import React, { Component } from 'react';
import PropTypes from 'prop-types';

import { Form, Input, Button, Select } from 'amos-framework';
import './../../../styles/view/patrol/inputItem.scss';
import { queryAllRouteAction } from '../../../services/checkService';

const FormItem = Form.Item;
const Option = Select.Option;
const planTypeData = [{ id: '1', name: '天' }, { id: '2', name: '周' }, { id: '3', name: '月' }, { id: '4', name: '年' }];

/**
 * 巡检计划查询
 *
 * @class PlanSearch
 * @extends {Component}
 */
class PlanSearch extends Component {
  constructor(props) {
    super(props);
    this.state = {
      form: {
        name: {
          name: 'name',
          value: ''
        },
        planType: {
          name: 'planType',
          value: ''
        },
        routeId: {
          name: 'routeId',
          value: ''
        },
        remark: {
          name: 'remark',
          value: ''
        }
      },
      routeData: []
    };
  }

  componentWillMount = () => {
    this.queryRouteByOrgCode();
  };

  queryRouteByOrgCode = () => {
    queryAllRouteAction().then(data => {
      let routeData = data;
      this.setState({ routeData: routeData });
    });
  };

  handleSubmit = () => {
    let { form } = this.state;
    const param = { pageNumber: 0, pageSize: 10 };
    this.props.search(form, param);
  };

  onChange = (key, e) => {
    let { form } = this.state;
    form[key].value = e.target.value;
    this.setState(form);
  };

  onSelectChange = (key, value) => {
    let { form } = this.state;
    form[key].value = value;
    this.setState(form);
  };

  render() {
    const { form, routeData } = this.state;
    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 4 },
        className: 'colspanlab'
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 14 },
        className: 'colspan'
      }
    };
    return (
      <Form style={{ padding: '30px 0 0 0' }} className="basic-demo" model={form}>
        <FormItem label={<span>计划名称</span>} field="name" {...formItemLayout}>
          <Input value={form.name.value} prefixCls="" className="search_Input" onChange={e => this.onChange('name', e)} />
        </FormItem>
        <FormItem label="计划类型" field="planType" {...formItemLayout}>
          <Select
            data={planTypeData}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            defaultOption={<Option value="">全部</Option>}
            value={form.planType.value}
            className="search_Input"
            onChange={e => this.onSelectChange('planType', e)}
          />
        </FormItem>
        <FormItem label="巡检路线" field="routeId" {...formItemLayout}>
          <Select
            searchable
            data={routeData}
            renderOption={item => <Option value={item.id}>{item.name}</Option>}
            defaultOption={<Option value="">全部</Option>}
            value={form.routeId.value}
            className="search_Input"
            onChange={e => this.onSelectChange('routeId', e)}
          />
        </FormItem>
        <FormItem label={<span>备注说明</span>} field="remark" {...formItemLayout}>
          <Input  value={form.remark.value} prefixCls="" className="search_Input"  onChange={e => this.onChange('remark', e)} />
        </FormItem>
        <FormItem  className="search-btn">
          <Button icon="search" onClick={this.handleSubmit}>
            查询
          </Button>
        </FormItem>
      </Form>
    );
  }
}

PlanSearch.propTypes = {};

export default PlanSearch;
