import React, { Component } from 'react';
import { Drawer, Icon } from 'amos-framework';
import PropTypes from 'prop-types';
import PointSearch from './PointSearch';

const Header = Drawer.Header;
const Content = Drawer.Content;

class PointDrawer extends Component {
  constructor(props) {
    super(props);

    this.state = {
      drawerOpen1: true
    };
    this.closeDrawer1 = this.closeDrawer1.bind(this);
    this.onDrawerClose1 = this.onDrawerClose1.bind(this);
    this.openDrawer1 = this.openDrawer1.bind(this);
  }

  onDrawerClose1() {
    this.setState({
      drawerOpen1: false
    });
  }

  closeDrawer1() {
    this.setState({
      drawerOpen1: false
    });
  }

  openDrawer1() {
    this.setState({
      drawerOpen1: true
    });
  }

  render() {
    const { drawerOpen1 } = this.state;
    let position = 'right';
    let disableOverlay = true;

    return (
      <div className='point-view-drawer'>
        <div className='point-view-drawer-title1' onClick={this.openDrawer1} hidden={drawerOpen1}><Icon icon="left" /></div>
        <Drawer title='查询条件1' open={drawerOpen1} position={position} disableOverlay={disableOverlay} onClose={this.onDrawerClose1}>
          <Header>
            <Icon onClick={this.closeDrawer1} icon="right" />
          </Header>
          <Content>
            <PointSearch search={this.props.queryTableData} />
          </Content>
        </Drawer>
      </div>
    );
  }
}

PointDrawer.propTypes = {
  queryTableData: PropTypes.func
};

export default PointDrawer;
