import React, { Component } from 'react';
import { SplitPane, Button, AmosAlert, CardPane } from 'amos-framework';
import { browserHistory } from 'amos-react-router';
import PointBasicInfo from './../point/PointBasicInfo';
import PointInputItemInfo from './../point/PointInputItemInfo';
import PointCatalogInfo from './../point/PointCatalogInfo';
import { addPointAction } from '../../../services/pointService';
import { queryInputItemByConditionAction1 } from './../../../services/checkService';
import HasPermission from './../../component/toolbar/hasPermission';

class PointInfo extends Component {
  constructor(props) {
    super(props);

    this.state = {
      basicInfoFormData: {},
      pointInputItemData: [],
      catalogInputItemData: [],
      basicInfoForm: {}
    };

    this.onBasicInfoFormChange = this.onBasicInfoFormChange.bind(this);
    this.handleSubmit = this.handleSubmit.bind(this);
    this.handleCancel = this.handleCancel.bind(this);
  }

  componentWillMount() {
    // queryInputItemByConditionAction().then(data => {
    //   this.setState({ inputItemData: data });
    // });
    this.queryInputItem();
  }

  onInputItemTableValueChange = values => {
    this.setState({ pointInputItemData: values });
  };

  onCatalogTableValueChange = values => {
    this.setState({ catalogInputItemData: values });
  };

  onBasicInfoFormChange(data, form) {
    this.setState({ basicInfoFormData: data });
    this.setState({ basicInfoForm: form });
  }

  queryInputItem = (searchParams) => {
    let params = new Array();
    if (searchParams) {
      params.push(searchParams);
    }
    queryInputItemByConditionAction1(params).then(data => {
      this.setState({ inputItemData: data });
    });
  }

  handleSubmit() {
    let { pointInputItemData, catalogInputItemData } = this.state;

    // e.preventDefault();
    let basicInfoForm = this.pointBasicInfo.form;
    let basicInfoFormData = basicInfoForm.props.model;

    if (basicInfoForm.validate === undefined) {
      AmosAlert.warning('提示', '请先输入点基础信息');
      return;
    }
    basicInfoForm.validate((valid, dataValues) => {
      if (valid) {
        let pointParam = this.preparePointParam(basicInfoFormData, pointInputItemData, catalogInputItemData);

        addPointAction(pointParam).then(
          data => {
            AmosAlert.success('提示', '保存成功');
            browserHistory.goBack('/main/patrol/point');
          },
          error => {
            AmosAlert.error('错误', '保存失败');
          }
        );
      } else {
        console.log('error submit!!');
        return false;
      }
    });
  }

  preparePointParam(basicInfoFormData, pointInputItemData, catalogInputItemData) {
    let pointParam = Object();
    let point = Object();

    Object.assign(point, basicInfoFormData);

    pointParam.point = point;
    if (pointParam.point.routeId !== '') {
      pointParam.point.routeId = pointParam.point.routeId.join();
      pointParam.point.routeName = pointParam.point.routeName.join();
    }
    pointParam.pointPhotoList = [];

    pointParam.inputItemVoInfo = pointInputItemData;
    for (let i = 0; i < pointInputItemData.length; i++) {
      pointInputItemData[i].pOrderNo = pointInputItemData[i].orderNo;
    }

    pointParam.pointClassifyList = [];
    pointParam.classifyInputItemMap = {};
    if (catalogInputItemData !== undefined) {
      for (let i = 0; i < catalogInputItemData.length; i++) {
        if (catalogInputItemData[i].name !== undefined) {
          let pointClassify = Object();
          pointClassify.name = catalogInputItemData[i].name;
          pointClassify.orderNo = catalogInputItemData[i].orderNo;
          pointParam.pointClassifyList.push(pointClassify);

          let catalogName = catalogInputItemData[i].name;
          let catalogItem = catalogInputItemData[i].inputItemId;

          pointParam.classifyInputItemMap[catalogName] = catalogItem;
        }
      }
    }

    return pointParam;
  }

  handleCancel = e => {
    browserHistory.goBack('/main/patrol/point');
  };

  render() {
    let { pointInputItemData, inputItemData } = this.state;
    let percentage = true;
    let catalogWithInputItem = {};
    return (
      <SplitPane vertical secondaryDefaultSize={8} percentage={percentage}>
        <SplitPane mainPaneIndex={1} secondaryDefaultSize={40} percentage={percentage}>
          <CardPane title="基础信息"  style={{ height: '100%' }}>
            <div>
              <PointBasicInfo
                onBasicInfoFormChange={this.onBasicInfoFormChange}
                ref={pointBasicInfo => this.pointBasicInfo = pointBasicInfo}
              />
            </div>
          </CardPane>
          <SplitPane secondaryDefaultSize={50} percentage={percentage}>
            <PointInputItemInfo inputItemData={inputItemData} pointInputItemData={pointInputItemData} onInputItemTableValueChange={this.onInputItemTableValueChange} queryInputItem={this.queryInputItem} />
            <PointCatalogInfo
              catalogWithInputItem={catalogWithInputItem}
              pointInputItemData={pointInputItemData}
              onCatalogTableValueChange={this.onCatalogTableValueChange}
            />
          </SplitPane>
        </SplitPane>
        <div className="point-info-footer" style={{ textAlign: 'center', marginTop: '1rem' }}>
          <HasPermission permissionCode='point'>
            <Button onClick={this.handleSubmit}>提交</Button>
          </HasPermission>
          <Button onClick={this.handleCancel}>返回</Button>
        </div>
      </SplitPane>
    );
  }
}

export default PointInfo;
