import React, { Component } from 'react';
import { MultiSelect, SplitPane, Button, Select } from 'amos-framework';
import PropTypes from 'prop-types';
import CommonTable from '../inputItem/CommonTable';
import '../../../styles/view/patrol/pointInputItemInfo.scss';
// import { queryInputItemByConditionAction } from './../../../services/checkService';

const MultiOption = MultiSelect.Option;
const Option = Select.Option;
const LevelEnum = { '-0': '无等级', '1': '1级', '2': '2级', '3': '3级', '4': '4级', '5': '5级' };

const pointInputItemColumns = () => {
  return [
    {
      title: '编号',
      dataIndex: 'itemNo',
      key: 'itemNo',
      width: '20%'
    },
    {
      title: '名称',
      dataIndex: 'name',
      key: 'name',
      width: '40%'
    },
    {
      title: '类型',
      dataIndex: 'itemType',
      key: 'itemType',
      width: '10%'
    },
    {
      title: '等级',
      dataIndex: 'level',
      key: 'level',
      width: '10%',
      render: (text) => {return LevelEnum[text];}
    },
    {
      title: '必填',
      dataIndex: 'isMust',
      key: 'isMust',
      width: '10%'
    },
    {
      title: '评分',
      dataIndex: 'isScore',
      key: 'isScore',
      width: '10%'
    }
  ];
};

/**
 * 巡检点项信息
 *
 * @class InputItemSearch
 * @extends {Component}
 */
class PointInputItemInfo extends Component {
  constructor(props) {
    super(props);
    this.state = {
      inputItemData: [],
      tableData: [],
      tempTableData: [],
      selectedRowKeys: [],
      selectedRows: [],
      moreData: [],
      pointInputItemData: []
    };
    this.onInputItemSelectChange = this.onInputItemSelectChange.bind(this);
    this.handleInputItemAdd = this.handleInputItemAdd.bind(this);
  }

  /**
   * 组件初始化调用
   */
  componentWillMount = () => {
    // queryInputItemByConditionAction().then(data => {
    //   this.setState({ inputItemData: data });
    // });
    // let { inputItemData } = this.props;
    // this.setState({ inputItemData });
  }

  componentWillReceiveProps = (nextProps) => {
    let { inputItemData } = nextProps || {};
    let { pointInputItemData } = nextProps || {};
    let pointItemData = [];
    for (let i = 0; i < pointInputItemData.length; i++) {
      pointItemData[pointInputItemData[i].orderNo] = pointInputItemData[i];
      inputItemData = inputItemData.filter(item => item.id !== pointInputItemData[i].id);
    }

    this.setState({
      pointInputItemData: pointItemData,
      inputItemData,
      moreData: []
    });
  }

  onInputItemTableValueChange = (values) => {
    this.setState({ tableData: values });
  }

  onInputItemSelectChange(keys) {
    let { inputItemData } = this.state;
    let tempTableData = new Array();
    this.multiSelectElement.setState({ searchValue: this.multiSelectElement.state.searchValue });
    for (let i in keys) {
      for (let j in inputItemData) {
        if (inputItemData[j].id === keys[i]) {
          let itemData = new Object();
          Object.assign(itemData, inputItemData[j]);
          tempTableData.push(itemData);
        }
      }
    }

    this.setState({
      tempTableData,
      moreData: []
    });
  }

  onSelectChange(value) {
    let searchParam = new Object();
    if (value === '-1') {
      searchParam = null;
    } else {
      searchParam.name = 'level';
      searchParam.value = value;
    }
    this.props.queryInputItem(searchParam);
  }

  handleInputItemAdd() {
    let { tempTableData, inputItemData } = this.state;
    let { pointInputItemData } = this.props;
    let pointInputItemRealData = [];
    let tempMoreData = [];
    Object.assign(pointInputItemRealData, pointInputItemData);
    for (let i = 0; i < tempTableData.length; i++) {
      // inputItemData = inputItemData.filter(item => item.id !== tempTableData[i].id );
      tempTableData[i].orderNo = -1;
      pointInputItemRealData.push(tempTableData[i]);
    }
    Object.assign(tempMoreData, tempTableData);
    for (let i = 0; i < tempTableData.length; i++) {
      let itemId = tempTableData[i].id;
      this.multiSelectElement.handleLabelRemove(itemId);
      inputItemData = inputItemData.filter(item => item.id !== itemId);
    }

    this.setState({
      moreData: tempMoreData,
      inputItemData,
      tempTableData: []
    }, () => this.props.onInputItemTableValueChange(pointInputItemRealData));
  }

  render() {
    let { inputItemData, moreData, pointInputItemData } = this.state;

    let { onInputItemTableValueChange, edit } = this.props;

    let addHide = true;
    let percentage = true;
    let hidden = edit ? edit : false;
    return (
      <div className="point-input-item">
        <div className="point-input-item-title" hidden={hidden}>
          <span>检查项目</span>
        </div>
        <SplitPane vertical mainPaneIndex={0} mainPaneMinSize={0} percentage={percentage} >
          <div className="point-input-item-table">
            <CommonTable tableData={pointInputItemData}
              moreData={moreData}
              onChangeTableValues={onInputItemTableValueChange}
              addHide={addHide}
              columns={pointInputItemColumns()}
              scroll={{ x: true, y: 150 }}
            />
          </div>
          <div style={{ paddingTop: '3px' }}>
            <div className='point-input-item-level'>
              <span>等级：</span>
              <Select defaultOption={<Option value='-1'>全部</Option>} className="search_Input" defaultValue='-1' onChange={(e) => this.onSelectChange(e)}>
                <Option value='-0'>无等级</Option>
                <Option value='1'>1级</Option>
                <Option value='2'>2级</Option>
                <Option value='3'>3级</Option>
                <Option value='4'>4级</Option>
                <Option value='5'>5级</Option>
              </Select>
            </div>
            <div className="point-input-item-add">
              <MultiSelect
                data={inputItemData}
                className="point-input-item-add-select"
                renderOption={item => <MultiOption value={item.id}>{(item.itemNo == "" ? '' : "["+item.itemNo+"]")+item.name }</MultiOption>}
                onChange={this.onInputItemSelectChange}
                ref={ref => this.multiSelectElement = ref}
              />
              <Button onClick={this.handleInputItemAdd}>添加</Button>
            </div>
          </div>
        </SplitPane>
      </div>
    );
  }
}

PointInputItemInfo.propTypes = {
  onInputItemTableValueChange: PropTypes.func,
  tableData: PropTypes.array,
  pointInputItemData: PropTypes.array,
  edit: PropTypes.bool,
  queryInputItem: PropTypes.func
};

export default PointInputItemInfo;
