import React, { Component } from 'react';
import { generateQRcode } from 'amos-core';
import PropTypes from 'amos-react-router/lib/PropTypes';
import { SplitPane, Button } from 'amos-framework';
import { toUtf8 } from './../../common/patrolUitl';
// import { QRCodePrefix } from './../../../consts/commonConsts';
import '../../../styles/view/patrol/PointQRCode.scss';

class PointQRCode extends Component {
  constructor(props) {
    super(props);
    this.state = {
      pointQRInfo: {}
    };
  }
  componentWillReceiveProps = (nextProps) => {
    let { pointQRInfo } = nextProps;
    this.setState(pointQRInfo);
  }
  generateQrTags = (value,code, cdata) => {
    return (
      '<div style="height: 150px; text-align: center; padding: 3px 5px; display: table; width: 100%; margin-top: 20px;"><div style="display: table-cell; vertical-align: middle;"><p style="font-size: 25px; text-align: center; margin-bottom: 2px; padding:0;">' +
      value +
      '</p><img src="' +
      cdata +
      '"/>'+
        '<p style="font-size: 30px; text-align: center; margin-top: 2px; padding:0;">'+code+'</p>'+
      '</div></div>'
    );
  };

  print(value,code, cdata) {
    let newWindow = window.open('打印二维码', '_blank');
    newWindow.document.write(this.generateQrTags(value,code,cdata));
    newWindow.document.close();
    setTimeout(() => {
      newWindow.print();
      newWindow.close();
    }, 100);
  }

  saveAs() {

  }

  downloadIamge(src, name) {
    let image = new Image();
    // 解决跨域 Canvas 污染问题
    image.setAttribute('crossOrigin', 'anonymous');
    image.onload = () => {
      let canvas = document.createElement('canvas');
      canvas.width = image.width;
      canvas.height = image.height;

      let context = canvas.getContext('2d');
      context.drawImage(image, 0, 0, image.width, image.height);
      let url = canvas.toDataURL('image/png');

      // 生成一个a元素
      let a = document.createElement('a');
      // 创建一个单击事件
      let event = new MouseEvent('click');

      // 将a的download属性设置为我们想要下载的图片名称，若name不存在则使用‘下载图片名称’作为默认名称
      a.download = name || '下载图片名称';
      // 将生成的URL设置为a.href属性
      a.href = url;

      // 触发a的单击事件
      a.dispatchEvent(event);
    };

    image.src = src;
  }

  

  render() {
    let { pointQRInfo } = this.props;
    const _true_ = true;
    const options = {
      value: toUtf8(pointQRInfo.pointNo),
      size: 250,
      fgColor: '#000000',
      bgColor: '#ffffff',
      level: 'H'
    };
    return (
      <div className="point-qr-print">
        <SplitPane vertical secondaryDefaultSize={8} percentage={_true_}>
          <div className="point-info-qr">
            <div className="point-info-name">
              <span className="QRPointName">{pointQRInfo.pointName}</span>
            </div>
            {<img className="" src={generateQRcode(options)} alt="" />}
            <div className="point-info-number">
              <span className="QRPointNo">{pointQRInfo.pointNo}</span>
            </div>
          </div>
          <div className="point-qr-print-button">
            <Button onClick={(e) => this.print(pointQRInfo.pointName,pointQRInfo.pointNo, generateQRcode(options))}>打印</Button>
            <Button onClick={(e) => this.downloadIamge(generateQRcode(options), pointQRInfo.pointName)}>另存</Button>
          </div>
        </SplitPane>
      </div>
    );
  }
}

PointQRCode.propTypes = {
  pointId: PropTypes.number,
  pointQRInfo: PropTypes.any
};

export default PointQRCode;
